"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentlessResources = useAgentlessResources;
var _react = require("react");
var _use_core = require("./use_core");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENTLESS_TOGGLE_STORAGE_KEY = 'fleet:showAgentlessResources';

/**
 * Hook to manage the agentless resources toggle state
 * @returns object with current state and setter function
 */
function useAgentlessResources() {
  const {
    storage
  } = (0, _use_core.useStartServices)();
  const initialValue = (0, _react.useMemo)(() => {
    try {
      const stored = storage.get(AGENTLESS_TOGGLE_STORAGE_KEY);
      return stored === true;
    } catch (error) {
      // In case storage is not available (e.g., in tests or restricted environments)
      return false;
    }
  }, [storage]);
  const [showAgentless, setShowAgentlessState] = (0, _react.useState)(initialValue);
  const setShowAgentless = (0, _react.useCallback)(enabled => {
    try {
      storage.set(AGENTLESS_TOGGLE_STORAGE_KEY, enabled);
      setShowAgentlessState(enabled);
    } catch (error) {
      // Silently fail if storage is not available, but still update state
      setShowAgentlessState(enabled);
    }
  }, [storage]);
  return {
    showAgentless,
    setShowAgentless
  };
}