"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Container = _styledComponents.default.div`
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  background-color: ${props => props.theme.eui.euiPageBackgroundColor};

  @media (max-width: 767px) {
    .euiFlexItem {
      margin-bottom: 0 !important;
    }
  }
`;
const Wrapper = _styledComponents.default.div`
  max-width: ${props => typeof props.maxWidth === 'number' ? `${props.maxWidth || 1200}px` || props.maxWidth : props.maxWidth};

  margin-left: auto;
  margin-right: auto;
  padding-top: ${props => props.theme.eui.euiSizeXL};
  padding-left: ${props => props.theme.eui.euiSizeM};
  padding-right: ${props => props.theme.eui.euiSizeM};
`;
const Tabs = (0, _styledComponents.default)(_eui.EuiTabs)`
  top: 1px;
  &:before {
    height: 0px;
  }
  ${({
  $tabsCss
}) => $tabsCss || ''}
`;
const HeaderColumns = /*#__PURE__*/(0, _react.memo)(({
  leftColumn,
  rightColumn,
  rightColumnGrow
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 5
  }
}, leftColumn ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 21
  }
}, leftColumn) : null, rightColumn ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: rightColumnGrow,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 22
  }
}, rightColumn) : null));
const Header = ({
  leftColumn,
  rightColumn,
  rightColumnGrow,
  topContent,
  tabs,
  maxWidth,
  tabsCss,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(Container, {
  "data-test-subj": dataTestSubj,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(Wrapper, {
  maxWidth: maxWidth,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 5
  }
}, topContent, /*#__PURE__*/_react.default.createElement(HeaderColumns, {
  leftColumn: leftColumn,
  rightColumn: rightColumn,
  rightColumnGrow: rightColumnGrow,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 7
  }
}, tabs ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(Tabs, {
  $tabsCss: tabsCss,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 13
  }
}, tabs.map((props, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, props, {
  key: `${props.id}-${index}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 89,
    columnNumber: 17
  }
}), props.name)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 13
  }
})))));
exports.Header = Header;