"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateAzureArmTemplateUrl = void 0;
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ARM_TEMPLATE_DEFAULT_ACCOUNT_TYPE = 'single-account';
const useCreateAzureArmTemplateUrl = ({
  enrollmentAPIKey,
  azureArmTemplateProps
}) => {
  var _data$items, _data$items$find, _data$items$find$host, _azureArmTemplateUrl;
  const {
    data,
    isLoading
  } = (0, _hooks.useGetFleetServerHosts)();
  let isError = false;
  let error;

  // Default fleet server host
  const fleetServerHost = data === null || data === void 0 ? void 0 : (_data$items = data.items) === null || _data$items === void 0 ? void 0 : (_data$items$find = _data$items.find(item => item.is_default)) === null || _data$items$find === void 0 ? void 0 : (_data$items$find$host = _data$items$find.host_urls) === null || _data$items$find$host === void 0 ? void 0 : _data$items$find$host[0];
  if (!fleetServerHost && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noFleetServerHost', {
      defaultMessage: 'No Fleet Server host found'
    });
  }
  if (!enrollmentAPIKey && !isLoading) {
    isError = true;
    error = _i18n.i18n.translate('xpack.fleet.agentEnrollment.cloudFormation.noApiKey', {
      defaultMessage: 'No enrollment token found'
    });
  }
  let azureArmTemplateUrl = azureArmTemplateProps === null || azureArmTemplateProps === void 0 ? void 0 : azureArmTemplateProps.templateUrl;
  if ((_azureArmTemplateUrl = azureArmTemplateUrl) !== null && _azureArmTemplateUrl !== void 0 && _azureArmTemplateUrl.includes('ACCOUNT_TYPE')) {
    azureArmTemplateUrl = azureArmTemplateUrl.replace('ACCOUNT_TYPE', (azureArmTemplateProps === null || azureArmTemplateProps === void 0 ? void 0 : azureArmTemplateProps.azureAccountType) || ARM_TEMPLATE_DEFAULT_ACCOUNT_TYPE);
  }
  return {
    isLoading,
    azureArmTemplateUrl,
    isError,
    error
  };
};
exports.useCreateAzureArmTemplateUrl = useCreateAzureArmTemplateUrl;