"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicySelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _agent_policy_package_badges = require("../agent_policy_package_badges");
var _hooks = require("../../hooks");
var _advanced_agent_authentication_settings = require("./advanced_agent_authentication_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agent_enrollment_flyout/agent_policy_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentPolicyFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  .euiFormRow__label {
    width: 100%;
  }
`;
const AgentPolicySelection = props => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const {
    agentPolicies,
    selectedPolicyId,
    setSelectedPolicyId,
    excludeFleetServer,
    onClickCreatePolicy,
    isFleetServerPolicy
  } = props;
  const authz = (0, _hooks.useAuthz)();

  // Memoize options to avoid recreating them on every render.
  // Important for performance when users have many policies.
  const policyOptions = (0, _react.useMemo)(() => agentPolicies.filter(policy => !(policy !== null && policy !== void 0 && policy.supports_agentless)).map(agentPolicy => ({
    value: agentPolicy.id,
    label: agentPolicy.name
  })), [agentPolicies]);

  // Memoize selected options to avoid unnecessary EuiComboBox re-renders
  const selectedOptions = (0, _react.useMemo)(() => {
    if (!selectedPolicyId) return [];
    const option = policyOptions.find(opt => opt.value === selectedPolicyId);
    return option ? [option] : [];
  }, [selectedPolicyId, policyOptions]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.selectAgentPolicyFleetServerText",
    defaultMessage: "Fleet Server runs on Elastic Agent, and agents are enrolled in agent policies which represent hosts. You can select an existing agent policy configured for Fleet Server, or you may choose to create a new one.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentStepAgentPolicy.createAgentPolicyText",
    defaultMessage: "Settings for the monitored host are configured in the {agentPolicy}. Choose an agent policy or create a new one.",
    values: {
      agentPolicy: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.agentPolicy,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.createAgentPolicyDocLink",
        defaultMessage: "agent policy",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(AgentPolicyFormRow, {
    fullWidth: true,
    label: authz.fleet.allAgentPolicies && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: onClickCreatePolicy,
      "data-test-subj": "createNewAgentPolicyLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollmentStepAgentPolicy.addPolicyButton",
      defaultMessage: "Create new agent policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 19
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    isLoading: !agentPolicies,
    options: policyOptions,
    selectedOptions: selectedOptions,
    onChange: newOptions => {
      if (newOptions.length) {
        setSelectedPolicyId(newOptions[0].value);
      } else {
        setSelectedPolicyId(undefined);
      }
    },
    singleSelection: {
      asPlainText: true
    },
    "aria-label": _i18n.i18n.translate('xpack.fleet.enrollmentStepAgentPolicy.policySelectAriaLabel', {
      defaultMessage: 'Agent policy'
    }),
    "data-test-subj": "agentPolicyDropdown",
    isInvalid: !selectedPolicyId,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  })), authz.fleet.readAgentPolicies && selectedPolicyId && !isFleetServerPolicy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_package_badges.AgentPolicyPackageBadges, {
    agentPolicyId: selectedPolicyId,
    excludeFleetServer: excludeFleetServer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  })), props.withKeySelection && props.onKeyChange && selectedPolicyId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_agent_authentication_settings.AdvancedAgentAuthenticationSettings, {
    selectedApiKeyId: props.selectedApiKeyId,
    onKeyChange: props.onKeyChange,
    initialAuthenticationSettingsOpen: !props.selectedApiKeyId,
    agentPolicyId: selectedPolicyId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  })));
};
exports.AgentPolicySelection = AgentPolicySelection;