"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EisCostTour = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/eis_cost_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EisCostTour = ({
  anchorPosition = 'downCenter',
  ctaLink,
  isCloudEnabled,
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isOpen,
    dismiss
  } = (0, _hooks.useDismissableTour)('EIS_COSTS');
  if (!isOpen || !isCloudEnabled) {
    return children;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    "data-test-subj": "fleetEisCostTour",
    title: _i18n.i18n.translate('xpack.fleet.eisCosts.tour.title', {
      defaultMessage: 'AI agents now understand your integrations'
    }),
    maxWidth: `${euiTheme.base * 25}px`,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.fleet.eisCosts.tour.description', {
      defaultMessage: 'Integration documentation and metadata are automatically indexed using Elastic Inference Service (EIS) to help agents understand your environment. Manage settings here.'
    }))),
    isStepOpen: isOpen,
    anchorPosition: anchorPosition,
    step: 1,
    stepsTotal: 1,
    onFinish: dismiss,
    footerAction: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "fleetEisCostTourCloseBtn",
      onClick: dismiss,
      "aria-label": _i18n.i18n.translate('xpack.fleet.eisCosts.tour.dismiss.aria', {
        defaultMessage: 'Close the cost tour'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.fleet.eisCosts.tour.dismiss', {
      defaultMessage: 'Dismiss'
    })), ...(ctaLink ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: false,
      color: "primary",
      size: "s",
      href: ctaLink,
      "data-test-subj": "eisCostsTourCtaBtn",
      target: "_blank",
      iconSide: "right",
      iconType: "popout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.fleet.eisCosts.tour.cta', {
      defaultMessage: 'Learn more'
    }))] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, children);
};
exports.EisCostTour = EisCostTour;