"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSingleAgentMenuItems = useSingleAgentMenuItems;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _services = require("../../../../../../common/services");
var _agent_status = require("../../../../../../common/services/agent_status");
var _hooks = require("../../../hooks");
var _services2 = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/hooks/use_single_agent_menu_items.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Callbacks interface for single-agent menu actions
 */

/**
 * Hook to generate standardized menu items for single-agent actions.
 * Used by both table row actions and agent details page actions menu.
 */
function useSingleAgentMenuItems({
  agent,
  agentPolicy,
  callbacks
}) {
  const authz = (0, _hooks.useAuthz)();
  const licenseService = (0, _hooks.useLicense)();
  const isUnenrolling = agent.status === 'unenrolling';
  const isAgentUpdating = (0, _agent_status.isStuckInUpdating)(agent);
  const hasFleetAllPrivileges = authz.fleet.allAgents;
  const agentPrivilegeLevelChangeEnabled = _services2.ExperimentalFeaturesService.get().enableAgentPrivilegeLevelChange;
  const menuItems = (0, _react.useMemo)(() => {
    const items = [];

    // View agent - only shown when onViewAgentClick is provided (table row context)
    if (callbacks.onViewAgentClick) {
      items.push({
        id: 'view-agent',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.viewActionText",
          defaultMessage: "View agent",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 76,
            columnNumber: 11
          }
        }),
        icon: 'inspect',
        onClick: () => {
          var _callbacks$onViewAgen;
          (_callbacks$onViewAgen = callbacks.onViewAgentClick) === null || _callbacks$onViewAgen === void 0 ? void 0 : _callbacks$onViewAgen.call(callbacks);
        }
      });
    }

    // Top-level (common-use) items (only if has privileges and not managed)
    if (hasFleetAllPrivileges && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed)) {
      items.push({
        id: 'tags',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.addRemoveTagsActionText",
          defaultMessage: "Add / remove tags",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 13
          }
        }),
        icon: 'tag',
        disabled: !agent.active,
        keepMenuOpen: true,
        onClick: event => {
          callbacks.onAddRemoveTagsClick(event.target.closest('button'));
        }
      }, {
        id: 'reassign',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.reassignActionText",
          defaultMessage: "Assign to new policy",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 13
          }
        }),
        icon: 'pencil',
        disabled: !agent.active && !agentPolicy || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
        onClick: () => {
          callbacks.onReassignClick();
        }
      }, {
        id: 'upgrade',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.upgradeOneButton",
          defaultMessage: "Upgrade agent",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 13
          }
        }),
        icon: 'refresh',
        disabled: !(0, _services2.isAgentUpgradeable)(agent) || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
        onClick: () => {
          callbacks.onUpgradeClick();
        },
        'data-test-subj': 'upgradeBtn'
      });
    }

    // Upgrade management submenu - conditionally shown if the user has privileges and the agent is upgradeable or actively upgrading
    if (hasFleetAllPrivileges && ((0, _services2.isAgentUpgradeable)(agent) || (0, _services.isAgentUpgrading)(agent))) {
      items.push({
        id: 'upgrade-management',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.upgradeManagement",
          defaultMessage: "Upgrade management",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 11
          }
        }),
        panelTitle: 'Upgrade management',
        children: [{
          id: 'restart-upgrade',
          name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.agentList.restartUpgradeOneButton",
            defaultMessage: "Restart upgrade",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 150,
              columnNumber: 15
            }
          }),
          icon: 'refresh',
          disabled: !isAgentUpdating,
          onClick: () => {
            callbacks.onUpgradeClick();
          },
          'data-test-subj': 'restartUpgradeBtn'
        }]
      });
    }

    // Maintenance and diagnostics submenu - always shown since View agent JSON is always available
    const maintenanceSubmenu = {
      id: 'maintenance',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.maintenanceAndDiagnostics",
        defaultMessage: "Maintenance and diagnostics",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 9
        }
      }),
      panelTitle: 'Maintenance and diagnostics',
      children: [
      // View agent JSON - always available
      {
        id: 'view-json',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.viewAgentDetailsJsonText",
          defaultMessage: "View agent JSON",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 181,
            columnNumber: 13
          }
        }),
        icon: 'code',
        onClick: () => {
          callbacks.onViewAgentJsonClick();
        },
        'data-test-subj': 'viewAgentDetailsJsonBtn'
      }]
    };

    // Migrate agent - only shown if the user has privileges and the agent is eligible for migration
    if (authz.fleet.allAgents && (0, _services.isAgentEligibleForMigration)(agent, agentPolicy)) {
      maintenanceSubmenu.children.push({
        id: 'migrate',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.migrateAgentActionText",
          defaultMessage: "Migrate agent",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 200,
            columnNumber: 11
          }
        }),
        icon: 'cluster',
        disabled: !agent.active || !licenseService.hasAtLeast(_constants.LICENSE_FOR_AGENT_MIGRATION),
        onClick: () => {
          callbacks.onMigrateAgentClick();
        },
        'data-test-subj': 'migrateAgentMenuItem'
      });
    }

    // Request diagnostics
    if (authz.fleet.readAgents) {
      maintenanceSubmenu.children.push({
        id: 'diagnostics',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.diagnosticsOneButton",
          defaultMessage: "Request diagnostics .zip",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 219,
            columnNumber: 11
          }
        }),
        icon: 'download',
        disabled: !(0, _services.isAgentRequestDiagnosticsSupported)(agent),
        onClick: () => {
          callbacks.onRequestDiagnosticsClick();
        },
        'data-test-subj': 'requestAgentDiagnosticsBtn'
      });
    }
    items.push(maintenanceSubmenu);

    // Security and removal submenu
    const securityChildren = [];

    // Remove root privilege
    if (authz.fleet.allAgents && (0, _services.isAgentEligibleForPrivilegeLevelChange)(agent, agentPolicy) && agentPrivilegeLevelChangeEnabled) {
      securityChildren.push({
        id: 'remove-root',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.changeAgentPrivilegeLevelActionText",
          defaultMessage: "Remove root privilege",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 247,
            columnNumber: 11
          }
        }),
        icon: 'lock',
        disabled: !agent.active,
        onClick: () => {
          callbacks.onChangeAgentPrivilegeLevelClick();
        },
        'data-test-subj': 'changeAgentPrivilegeLevelMenuItem'
      });
    }

    // Unenroll and Uninstall agent
    if (hasFleetAllPrivileges && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed)) {
      securityChildren.push({
        id: 'unenroll',
        name: isUnenrolling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.forceUnenrollOneButton",
          defaultMessage: "Force unenroll",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 266,
            columnNumber: 11
          }
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.unenrollOneButton",
          defaultMessage: "Unenroll agent",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 271,
            columnNumber: 11
          }
        }),
        icon: 'trash',
        iconColor: 'danger',
        disabled: !agent.active || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
        onClick: () => {
          callbacks.onUnenrollClick();
        },
        'data-test-subj': 'agentUnenrollBtn'
      });

      // Uninstall agent
      if (agent.policy_id && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless)) {
        securityChildren.push({
          id: 'uninstall',
          name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.agentList.getUninstallCommand",
            defaultMessage: "Uninstall agent",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 290,
              columnNumber: 13
            }
          }),
          icon: 'minusInCircle',
          iconColor: 'danger',
          disabled: !agent.active,
          onClick: () => {
            callbacks.onUninstallClick();
          },
          'data-test-subj': 'uninstallAgentMenuItem'
        });
      }
    }
    if (securityChildren.length > 0) {
      items.push({
        id: 'security',
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.agentList.securityAndRemoval",
          defaultMessage: "Security and removal",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 310,
            columnNumber: 11
          }
        }),
        panelTitle: 'Security and removal',
        children: securityChildren
      });
    }
    return items;
  }, [agent, agentPolicy, hasFleetAllPrivileges, authz.fleet.allAgents, authz.fleet.readAgents, isAgentUpdating, isUnenrolling, agentPrivilegeLevelChangeEnabled, licenseService, callbacks]);
  return menuItems;
}