"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnrollmentTokenListPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _api_key_field = require("../../../../../components/api_key_field");
var _constants = require("../../../constants");
var _components = require("../../../components");
var _hooks = require("../../../hooks");
var _search_bar = require("../../../components/search_bar");
var _layouts = require("../../../layouts");
var _confirm_delete_modal = require("./components/confirm_delete_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/enrollment_token_list_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteButton = ({
  apiKey,
  refresh
}) => {
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [state, setState] = (0, _react.useState)('CONFIRM_HIDDEN');
  const onCancel = () => setState('CONFIRM_HIDDEN');
  const onConfirm = async () => {
    try {
      const res = await (0, _hooks.sendDeleteOneEnrollmentAPIKey)(apiKey.id);
      if (res.error) {
        throw res.error;
      }
    } catch (err) {
      notifications.toasts.addError(err, {
        title: 'Error'
      });
    }
    setState('CONFIRM_HIDDEN');
    refresh();
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, state === 'CONFIRM_VISIBLE' && /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmEnrollmentTokenDelete, {
    enrollmentKey: apiKey,
    onCancel: onCancel,
    onConfirm: onConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel', {
      defaultMessage: 'Revoke token'
    }),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "enrollmentTokenTable.revokeBtn",
    "aria-label": _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel', {
      defaultMessage: 'Revoke token'
    }),
    onClick: () => setState('CONFIRM_VISIBLE'),
    iconType: "trash",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })));
};
const NOT_HIDDEN_KUERY = 'not hidden:true';
const EnrollmentTokenListPage = () => {
  var _enrollmentAPIKeysReq, _enrollmentAPIKeysReq2, _enrollmentAPIKeysReq3;
  (0, _hooks.useBreadcrumbs)('enrollment_tokens');
  const [isModalOpen, setModalOpen] = (0, _react.useState)(false);
  const [search, setSearch] = (0, _react.useState)('');
  const {
    pagination,
    setPagination,
    pageSizeOptions
  } = (0, _hooks.usePagination)();
  const enrollmentAPIKeysRequest = (0, _hooks.useGetEnrollmentAPIKeysQuery)({
    page: pagination.currentPage,
    perPage: pagination.pageSize,
    kuery: search.trim() !== '' ? `(${search}) and (${NOT_HIDDEN_KUERY})` : NOT_HIDDEN_KUERY
  });
  const agentPoliciesRequest = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const agentPolicies = agentPoliciesRequest.data ? agentPoliciesRequest.data.items : [];
  const agentPoliciesById = agentPolicies.reduce((acc, policy) => {
    acc[policy.id] = policy;
    return acc;
  }, {});
  const total = (_enrollmentAPIKeysReq = enrollmentAPIKeysRequest === null || enrollmentAPIKeysRequest === void 0 ? void 0 : (_enrollmentAPIKeysReq2 = enrollmentAPIKeysRequest.data) === null || _enrollmentAPIKeysReq2 === void 0 ? void 0 : _enrollmentAPIKeysReq2.total) !== null && _enrollmentAPIKeysReq !== void 0 ? _enrollmentAPIKeysReq : 0;
  const rowItems = (enrollmentAPIKeysRequest === null || enrollmentAPIKeysRequest === void 0 ? void 0 : (_enrollmentAPIKeysReq3 = enrollmentAPIKeysRequest.data) === null || _enrollmentAPIKeysReq3 === void 0 ? void 0 : _enrollmentAPIKeysReq3.items.filter(enrollmentKey => {
    if (!agentPolicies.length || !enrollmentKey.policy_id) return false;
    const agentPolicy = agentPoliciesById[enrollmentKey.policy_id];
    // Filter legacy enrollment api keys without the hidden flag
    return !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed) && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless);
  })) || [];
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.nameTitle', {
      defaultMessage: 'Name'
    }),
    render: value => /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      title: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }, value)
  }, {
    field: 'id',
    name: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.secretTitle', {
      defaultMessage: 'Secret'
    }),
    width: '215px',
    render: apiKeyId => {
      return /*#__PURE__*/_react.default.createElement(_api_key_field.ApiKeyField, {
        apiKeyId: apiKeyId,
        sendGetAPIKey: _hooks.sendGetOneEnrollmentAPIKey,
        tokenGetter: response => {
          var _response$data;
          return (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.item.api_key;
        },
        length: 60,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'policy_id',
    name: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.policyTitle', {
      defaultMessage: 'Agent policy'
    }),
    render: policyId => {
      const agentPolicy = agentPoliciesById[policyId];
      const value = agentPolicy ? agentPolicy.name : policyId;
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "eui-textTruncate",
        title: value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 11
        }
      }, value);
    }
  }, {
    field: 'created_at',
    name: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.createdAtTitle', {
      defaultMessage: 'Created on'
    }),
    width: '150px',
    render: createdAt => {
      return createdAt ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        year: "numeric",
        month: "short",
        day: "2-digit",
        value: createdAt,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 11
        }
      }) : null;
    }
  }, {
    field: 'active',
    name: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.activeTitle', {
      defaultMessage: 'Active'
    }),
    width: '70px',
    align: 'center',
    render: active => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        color: active ? 'success' : 'danger',
        type: "dot",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 16
        }
      });
    }
  }, {
    field: 'actions',
    name: _i18n.i18n.translate('xpack.fleet.enrollmentTokensList.actionsTitle', {
      defaultMessage: 'Actions'
    }),
    width: '70px',
    render: (_, apiKey) => {
      const agentPolicy = agentPolicies.find(c => c.id === apiKey.policy_id);
      const canUnenroll = apiKey.active && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed);
      return canUnenroll && /*#__PURE__*/_react.default.createElement(DeleteButton, {
        apiKey: apiKey,
        refresh: () => enrollmentAPIKeysRequest.refetch(),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 13
        }
      });
    }
  }];
  const isLoading = enrollmentAPIKeysRequest.isInitialLoading || agentPoliciesRequest.isLoading && agentPoliciesRequest.isInitialRequest;
  return /*#__PURE__*/_react.default.createElement(_layouts.DefaultLayout, {
    section: "enrollment_tokens",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 5
    }
  }, isModalOpen && /*#__PURE__*/_react.default.createElement(_components.NewEnrollmentTokenModal, {
    agentPolicies: agentPolicies,
    onClose: key => {
      setModalOpen(false);
      enrollmentAPIKeysRequest.refetch();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentTokensList.pageDescription",
    defaultMessage: "Create and revoke enrollment tokens. An enrollment token enables one or more agents to enroll in Fleet and send data.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    value: search,
    indexPattern: _constants.ENROLLMENT_API_KEYS_INDEX,
    fieldPrefix: _constants.FLEET_ENROLLMENT_API_PREFIX,
    onChange: newSearch => {
      setPagination({
        ...pagination,
        currentPage: 1
      });
      setSearch(newSearch);
    },
    dataTestSubj: "enrollmentKeysList.queryInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createEnrollmentTokenButton",
    fill: true,
    iconType: "plusInCircle",
    onClick: () => setModalOpen(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.enrollmentTokensList.newKeyButton",
    defaultMessage: "Create enrollment token",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "enrollmentTokenListTable",
    loading: isLoading,
    noItemsMessage: isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollemntAPIKeyList.loadingTokensMessage",
      defaultMessage: "Loading enrollment tokens...",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.enrollemntAPIKeyList.emptyMessage",
      defaultMessage: "No enrollment tokens found.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 13
      }
    }),
    items: total ? rowItems : [],
    itemId: "id",
    columns: columns,
    pagination: {
      pageIndex: pagination.currentPage - 1,
      pageSize: pagination.pageSize,
      totalItemCount: total,
      pageSizeOptions
    },
    onChange: ({
      page
    }) => {
      const newPagination = {
        ...pagination,
        currentPage: page.index + 1,
        pageSize: page.size
      };
      setPagination(newPagination);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 7
    }
  }));
};
exports.EnrollmentTokenListPage = EnrollmentTokenListPage;