"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackagePolicyWithRelatedData = usePackagePolicyWithRelatedData;
var _react = require("react");
var _jsYaml = require("js-yaml");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _hooks = require("../../../../hooks");
var _services = require("../../create_package_policy_page/services");
var _utils = require("../utils");
var _prepare_input_pkg_policy_dataset = require("../../create_package_policy_page/services/prepare_input_pkg_policy_dataset");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeVars(packageVars, userVars = {}) {
  if (!packageVars) {
    return {};
  }
  return Object.entries(packageVars).reduce((acc, [varKey, varRecord]) => {
    var _userVars$varKey$valu, _userVars$varKey;
    acc[varKey] = {
      ...varRecord,
      value: (_userVars$varKey$valu = userVars === null || userVars === void 0 ? void 0 : (_userVars$varKey = userVars[varKey]) === null || _userVars$varKey === void 0 ? void 0 : _userVars$varKey.value) !== null && _userVars$varKey$valu !== void 0 ? _userVars$varKey$valu : varRecord.value
    };
    return acc;
  }, {});
}
async function isPreleaseEnabled() {
  const {
    data: settings
  } = await (0, _hooks.sendGetSettings)();
  return Boolean(settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled);
}
function usePackagePolicyWithRelatedData(packagePolicyId, options) {
  var _options$forceUpgrade;
  const [packageInfo, setPackageInfo] = (0, _react.useState)();
  const [packagePolicy, setPackagePolicy] = (0, _react.useState)({
    name: '',
    description: '',
    namespace: '',
    policy_id: '',
    policy_ids: [],
    enabled: true,
    inputs: [],
    version: ''
  });
  const [originalPackagePolicy, setOriginalPackagePolicy] = (0, _react.useState)();
  const [agentPolicies, setAgentPolicies] = (0, _react.useState)([]);
  const [isLoadingData, setIsLoadingData] = (0, _react.useState)(true);
  const [dryRunData, setDryRunData] = (0, _react.useState)();
  const [loadingError, setLoadingError] = (0, _react.useState)();
  const [isUpgrade, setIsUpgrade] = (0, _react.useState)((_options$forceUpgrade = options.forceUpgrade) !== null && _options$forceUpgrade !== void 0 ? _options$forceUpgrade : false);

  // Form state
  const [isEdited, setIsEdited] = (0, _react.useState)(false);
  const [formState, setFormState] = (0, _react.useState)('INVALID');
  const [validationResults, setValidationResults] = (0, _react.useState)();
  const hasErrors = validationResults ? (0, _services.validationHasErrors)(validationResults) : false;
  const savePackagePolicy = async packagePolicyOverride => {
    setFormState('LOADING');
    const {
      policy: {
        elasticsearch,
        ...restPackagePolicy
      }
    } = await (0, _prepare_input_pkg_policy_dataset.prepareInputPackagePolicyDataset)((0, _lodash.omit)({
      ...packagePolicy,
      ...(packagePolicyOverride !== null && packagePolicyOverride !== void 0 ? packagePolicyOverride : {})
    }, 'spaceIds'));
    const result = await (0, _hooks.sendUpdatePackagePolicy)(packagePolicyId, restPackagePolicy);
    setFormState('SUBMITTED');
    return result;
  };
  // Update package policy validation
  const updatePackagePolicyValidation = (0, _react.useCallback)(newPackagePolicy => {
    if (packageInfo) {
      const newValidationResult = (0, _services.validatePackagePolicy)(newPackagePolicy || packagePolicy, packageInfo, _jsYaml.load);
      setValidationResults(newValidationResult);
      // eslint-disable-next-line no-console
      console.debug('Package policy validation results', newValidationResult);
      return newValidationResult;
    }
  }, [packagePolicy, packageInfo]);
  // Update package policy method
  const updatePackagePolicy = (0, _react.useCallback)(updatedFields => {
    const isDeepEqual = (0, _fastDeepEqual.default)(JSON.parse(JSON.stringify(updatedFields)), JSON.parse(JSON.stringify((0, _lodash.pick)(packagePolicy, Object.keys(updatedFields)))));
    if (!isDeepEqual) {
      setIsEdited(true);
    }
    const newPackagePolicy = {
      ...packagePolicy,
      ...updatedFields
    };
    setPackagePolicy(newPackagePolicy);

    // eslint-disable-next-line no-console
    console.debug('Package policy updated', newPackagePolicy);
    const newValidationResults = updatePackagePolicyValidation(newPackagePolicy);
    const hasValidationErrors = newValidationResults ? (0, _services.validationHasErrors)(newValidationResults) : false;
    if (!hasValidationErrors) {
      setFormState('VALID');
    } else {
      setFormState('INVALID');
    }
  }, [packagePolicy, updatePackagePolicyValidation]);

  // Load the package policy and related data
  (0, _react.useEffect)(() => {
    const getData = async () => {
      setIsLoadingData(true);
      setLoadingError(undefined);
      try {
        var _upgradePackagePolicy, _upgradePackagePolicy2;
        const prerelease = await isPreleaseEnabled();
        const {
          data: packagePolicyData,
          error: packagePolicyError
        } = await (0, _hooks.sendGetOnePackagePolicy)(packagePolicyId);
        if (packagePolicyError) {
          throw packagePolicyError;
        }
        if (packagePolicyData.item.policy_ids && packagePolicyData.item.policy_ids.length > 0) {
          var _data$items;
          const {
            data,
            error: agentPolicyError
          } = await (0, _hooks.sendBulkGetAgentPolicies)(packagePolicyData.item.policy_ids);
          if (agentPolicyError) {
            throw agentPolicyError;
          }
          setAgentPolicies((_data$items = data === null || data === void 0 ? void 0 : data.items) !== null && _data$items !== void 0 ? _data$items : []);
        }
        const {
          data: upgradePackagePolicyDryRunData,
          error: upgradePackagePolicyDryRunError
        } = await (0, _hooks.sendUpgradePackagePolicyDryRun)([packagePolicyId]);
        if (upgradePackagePolicyDryRunError) {
          throw upgradePackagePolicyDryRunError;
        }
        const hasUpgrade = upgradePackagePolicyDryRunData ? (0, _utils.hasUpgradeAvailable)(upgradePackagePolicyDryRunData) : false;
        const isUpgradeScenario = options.forceUpgrade && hasUpgrade;
        // If the dry run data doesn't indicate a difference in version numbers, flip the form back
        // to its non-upgrade state, even if we were initially set to the upgrade view
        if (!hasUpgrade) {
          setIsUpgrade(false);
        }
        if (upgradePackagePolicyDryRunData && hasUpgrade) {
          setDryRunData(upgradePackagePolicyDryRunData);
        }
        const basePolicy = packagePolicyData === null || packagePolicyData === void 0 ? void 0 : packagePolicyData.item;
        let baseInputs = basePolicy === null || basePolicy === void 0 ? void 0 : basePolicy.inputs;
        let basePackage = basePolicy === null || basePolicy === void 0 ? void 0 : basePolicy.package;
        let baseVars = basePolicy === null || basePolicy === void 0 ? void 0 : basePolicy.vars;
        const proposedUpgradePackagePolicy = upgradePackagePolicyDryRunData === null || upgradePackagePolicyDryRunData === void 0 ? void 0 : (_upgradePackagePolicy = upgradePackagePolicyDryRunData[0]) === null || _upgradePackagePolicy === void 0 ? void 0 : (_upgradePackagePolicy2 = _upgradePackagePolicy.diff) === null || _upgradePackagePolicy2 === void 0 ? void 0 : _upgradePackagePolicy2[1];
        if (isUpgradeScenario) {
          if (!proposedUpgradePackagePolicy) {
            throw new Error('There was an error when trying to load upgrade diff for that package policy');
          }
          // If we're upgrading the package, we need to "start from" the policy as it's returned from
          // the dry run so we can allow the user to edit any new variables before saving + upgrading
          baseInputs = proposedUpgradePackagePolicy.inputs;
          basePackage = proposedUpgradePackagePolicy.package;
          baseVars = proposedUpgradePackagePolicy.vars;
        }
        if (basePolicy) {
          setOriginalPackagePolicy(basePolicy);
          const {
            id,
            revision,
            inputs,
            vars,
            created_by,
            created_at,
            updated_by,
            updated_at,
            secret_references,
            ...restOfPackagePolicy
          } = basePolicy;

          // const newVars = baseVars;

          // Remove `compiled_stream` from all stream info, we assign this after saving
          const newPackagePolicy = {
            ...restOfPackagePolicy,
            // If we're upgrading, we need to make sure we catch an addition of package-level
            // vars when they were previously no package-level vars defined
            vars: mergeVars(baseVars, vars),
            inputs: baseInputs.map(input => {
              var _basePolicy$inputs$fi;
              // Remove `compiled_input` from all input info, we assign this after saving
              const {
                streams,
                compiled_input: compiledInput,
                vars: inputVars,
                ...restOfInput
              } = input;
              const basePolicyInputVars = isUpgradeScenario && ((_basePolicy$inputs$fi = basePolicy.inputs.find(i => i.type === input.type && i.policy_template === input.policy_template)) === null || _basePolicy$inputs$fi === void 0 ? void 0 : _basePolicy$inputs$fi.vars);
              let newInputVars = inputVars;
              if (basePolicyInputVars && inputVars) {
                // merging vars from dry run with updated ones
                newInputVars = mergeVars(inputVars, basePolicyInputVars);
              }
              // Fix duration vars, if it's a migrated setting, and it's a plain old number with no suffix
              if (basePackage.name === 'apm') {
                newInputVars = (0, _utils.fixApmDurationVars)(newInputVars);
              }
              return {
                ...restOfInput,
                streams: streams.map(stream => {
                  const {
                    compiled_stream,
                    ...restOfStream
                  } = stream;
                  return restOfStream;
                }),
                vars: newInputVars
              };
            }),
            package: basePackage
          };
          setPackagePolicy(newPackagePolicy);
          if (basePolicy.package) {
            var _upgradePackagePolicy3, _upgradePackagePolicy4, _upgradePackagePolicy5;
            let _packageInfo = basePolicy.package;

            // When upgrading, we need to grab the `packageInfo` data from the new package version's
            // proposed policy (comes from the dry run diff) to ensure we have the valid package key/version
            // before saving
            if (isUpgradeScenario && !!(upgradePackagePolicyDryRunData !== null && upgradePackagePolicyDryRunData !== void 0 && (_upgradePackagePolicy3 = upgradePackagePolicyDryRunData[0]) !== null && _upgradePackagePolicy3 !== void 0 && (_upgradePackagePolicy4 = _upgradePackagePolicy3.diff) !== null && _upgradePackagePolicy4 !== void 0 && (_upgradePackagePolicy5 = _upgradePackagePolicy4[1]) !== null && _upgradePackagePolicy5 !== void 0 && _upgradePackagePolicy5.package)) {
              var _upgradePackagePolicy6, _upgradePackagePolicy7;
              _packageInfo = (_upgradePackagePolicy6 = upgradePackagePolicyDryRunData[0].diff) === null || _upgradePackagePolicy6 === void 0 ? void 0 : (_upgradePackagePolicy7 = _upgradePackagePolicy6[1]) === null || _upgradePackagePolicy7 === void 0 ? void 0 : _upgradePackagePolicy7.package;
            }
            const {
              data: packageData
            } = await (0, _hooks.sendGetPackageInfoByKey)(_packageInfo.name, _packageInfo.version, {
              prerelease,
              full: true
            });
            if (packageData !== null && packageData !== void 0 && packageData.item) {
              setPackageInfo(packageData.item);
              const newValidationResults = (0, _services.validatePackagePolicy)(newPackagePolicy, packageData.item, _jsYaml.load);
              setValidationResults(newValidationResults);
              if ((0, _services.validationHasErrors)(newValidationResults)) {
                setFormState('INVALID');
              } else {
                setFormState('VALID');
              }
            }
          }
        }
      } catch (e) {
        setLoadingError(e);
      }
      setIsLoadingData(false);
    };
    getData();
  }, [packagePolicyId, options.forceUpgrade]);
  return {
    // form
    formState,
    validationResults,
    hasErrors,
    upgradeDryRunData: dryRunData,
    setFormState,
    updatePackagePolicy,
    isEdited,
    setIsEdited,
    // data
    packageInfo,
    isUpgrade,
    savePackagePolicy,
    isLoadingData,
    agentPolicies,
    loadingError,
    packagePolicy,
    originalPackagePolicy
  };
}