"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIntegrationFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _components = require("../../../../agents/components");
var _hooks = require("../../../../../hooks");
var _single_page_layout = require("../../../create_package_policy_page/single_page_layout");
var _use_available_packages = require("../../../../../../integrations/sections/epm/screens/home/hooks/use_available_packages");
var _components2 = require("../../../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/components/package_policies/add_integration_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddIntegrationFlyout = ({
  onClose,
  agentPolicy
}) => {
  var _selectedOptions$, _selectedOptions$2, _selectedOptions$3;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [prerelease, setPrerelease] = _react.default.useState(false);
  const {
    data: settings
  } = (0, _hooks.useGetSettings)();
  (0, _react.useEffect)(() => {
    const isEnabled = Boolean(settings === null || settings === void 0 ? void 0 : settings.item.prerelease_integrations_enabled);
    if (settings !== null && settings !== void 0 && settings.item) {
      setPrerelease(isEnabled);
    }
  }, [settings === null || settings === void 0 ? void 0 : settings.item]);
  const {
    filteredCards,
    isLoading
  } = (0, _use_available_packages.useAvailablePackages)({
    prereleaseIntegrationsEnabled: prerelease
  });
  const options = (0, _react.useMemo)(() => {
    return filteredCards.filter(pkg => {
      var _pkg$type;
      return ['integration', 'input'].includes((_pkg$type = pkg.type) !== null && _pkg$type !== void 0 ? _pkg$type : '');
    }).map(pkg => ({
      label: pkg.title,
      value: pkg.name,
      integration: pkg.integration,
      prepend: /*#__PURE__*/_react.default.createElement(_components2.PackageIcon, {
        packageName: pkg.name,
        version: pkg.version,
        integrationName: pkg.integration,
        size: "l",
        tryApi: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      })
    }));
  }, [filteredCards]);
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  const [isSubmitted, setIsSubmitted] = (0, _react.useState)(false);
  const [hasErrors, setHasErrors] = (0, _react.useState)(false);
  const updateHasErrors = (0, _react.useCallback)(errors => {
    setHasErrors(errors);
  }, [setHasErrors]);
  const onChange = (0, _react.useCallback)(selected => {
    setSelectedOptions(selected);
  }, []);
  const selectIntegrationStep = {
    title: _i18n.i18n.translate('xpack.fleet.addIntegrationFlyout.selectIntegrationTitle', {
      defaultMessage: 'Select integration'
    }),
    'data-test-subj': 'selectIntegrationStep',
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addIntegrationFlyout.selectIntegrationDescription",
      defaultMessage: "Search our integrations collection.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      "aria-label": "Select integration",
      placeholder: "Select integrations...",
      singleSelection: {
        asPlainText: true
      },
      options: options,
      selectedOptions: selectedOptions,
      onChange: onChange,
      isLoading: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    })),
    headingElement: 'h2'
  };
  const onSubmitCompleted = (0, _react.useCallback)(() => {
    setIsSubmitted(false);
    onClose();
  }, [onClose]);
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_components.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "addIntegrationFlyout",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.flyoutHeaderTitle",
    defaultMessage: "Add integration to policy",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 21
    }
  }, agentPolicy.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.flyoutHeaderDescription",
    defaultMessage: "You are adding an integration to the selected policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_single_page_layout.CreatePackagePolicySinglePage, {
    from: "policy",
    queryParamsPolicyId: agentPolicy.id,
    prerelease: prerelease,
    pkgLabel: (_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : _selectedOptions$.label,
    pkgName: (_selectedOptions$2 = selectedOptions[0]) === null || _selectedOptions$2 === void 0 ? void 0 : _selectedOptions$2.value,
    integration: (_selectedOptions$3 = selectedOptions[0]) === null || _selectedOptions$3 === void 0 ? void 0 : _selectedOptions$3.integration,
    addIntegrationFlyoutProps: {
      selectIntegrationStep,
      onSubmitCompleted,
      isSubmitted,
      agentPolicy,
      updateHasErrors
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }), isSubmitted && /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
    headerZindexLocation: "below",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "addIntegrationFlyout.cancelBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 15
    }
  }, hasErrors ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.errorOnSaveText",
    defaultMessage: "Your integration policy has errors.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 19
    }
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: isSubmitted || selectedOptions.length === 0 || hasErrors,
    isLoading: isSubmitted,
    onClick: () => {
      setIsSubmitted(true);
    },
    "data-test-subj": "addIntegrationFlyout.submitBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegrationFlyout.submitButton",
    defaultMessage: "Add integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 19
    }
  }))))))));
};
exports.AddIntegrationFlyout = AddIntegrationFlyout;