"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageAutoUpgradeAgentsBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/details_page/components/header/manage_auto_upgrade_agents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManageAutoUpgradeAgentsBadge = ({
  agentPolicy,
  isManageAutoUpgradeAgentsModalOpen,
  setIsManageAutoUpgradeAgentsModalOpen
}) => {
  var _agentPolicy$required, _agentPolicy$required2, _agentPolicy$required3;
  const {
    data: autoUpgradeAgentsStatus
  } = (0, _hooks.useGetAutoUpgradeAgentsStatusQuery)(agentPolicy.id);
  const requiredVersions = ((_agentPolicy$required = agentPolicy.required_versions) !== null && _agentPolicy$required !== void 0 ? _agentPolicy$required : []).map(reqVersion => reqVersion.version);
  const hasErrors = (0, _react.useMemo)(() => {
    return autoUpgradeAgentsStatus === null || autoUpgradeAgentsStatus === void 0 ? void 0 : autoUpgradeAgentsStatus.currentVersions.filter(value => requiredVersions.includes(value.version)).some(value => value.failedUpgradeAgents > 0);
  }, [autoUpgradeAgentsStatus, requiredVersions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    id: "auto-upgrade-manage-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsManageAutoUpgradeAgentsModalOpen(!isManageAutoUpgradeAgentsModalOpen);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.summary.autoUpgradeButton",
    defaultMessage: "Manage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: (_agentPolicy$required2 = agentPolicy.required_versions) !== null && _agentPolicy$required2 !== void 0 && _agentPolicy$required2.length ? 'accent' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, ((_agentPolicy$required3 = agentPolicy.required_versions) === null || _agentPolicy$required3 === void 0 ? void 0 : _agentPolicy$required3.length) || 0)), hasErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.failedUpgradeTooltip",
      defaultMessage: "Some agents failed to upgrade, click on Manage to see details.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 15
      }
    }),
    type: "warning",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  })));
};
exports.ManageAutoUpgradeAgentsBadge = ManageAutoUpgradeAgentsBadge;