"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../../common/constants");
var _global_data_tags_table = require("./global_data_tags_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agent_policy/components/agent_policy_advanced_fields/custom_fields/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Fix to align description to top during empty state w/ unsupported callout
const DescribedFormGroup = (0, _styledComponents.default)(_eui.EuiDescribedFormGroup)`
  .euiFlexGroup {
    align-items: flex-start;
  }
`;
const CustomFields = ({
  agentPolicy,
  updateAgentPolicy,
  isDisabled
}) => {
  const isAgentPolicy = policy => {
    return policy.package_policies !== undefined;
  };
  const findUnsupportedInputs = (policy, excludedInputs) => {
    var _policy$package_polic;
    if (!isAgentPolicy(policy)) {
      return [];
    }
    const found = new Set([]);
    (_policy$package_polic = policy.package_policies) === null || _policy$package_polic === void 0 ? void 0 : _policy$package_polic.forEach(p => {
      p.inputs.forEach(input => {
        if (excludedInputs.has(input.type)) {
          found.add(input.type);
        }
      });
    });
    return Array.from(found);
  };
  const unsupportedInputs = findUnsupportedInputs(agentPolicy, _constants.GLOBAL_DATA_TAG_EXCLUDED_INPUTS);
  return /*#__PURE__*/_react.default.createElement(DescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.globalDataTagHeader",
      defaultMessage: "Custom fields",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.globalDataTagDescription",
      defaultMessage: "Add a field and value set to all data collected from the agents enrolled in this policy.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }), unsupportedInputs.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentPolicyForm.globalDataTagUnsupportedInputTitle",
        defaultMessage: "Unsupported inputs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 19
        }
      }),
      color: "warning",
      iconType: "alert",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.globalDataTagUnsupportedInputMessage",
      defaultMessage: "Tagging data collected from {inputCount, plural, one {input {inputs} is} other {inputs {inputs} are}} not supported.",
      values: {
        inputCount: unsupportedInputs.length,
        inputs: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 31
          }
        }, unsupportedInputs.join(', '))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 19
      }
    })))) : null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_global_data_tags_table.GlobalDataTagsTable, {
    isDisabled: isDisabled,
    updateAgentPolicy: updateAgentPolicy,
    globalDataTags: agentPolicy.global_data_tags ? agentPolicy.global_data_tags : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }));
};
exports.CustomFields = CustomFields;