"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callImportRoute = callImportRoute;
exports.callInitializeImportRoute = callInitializeImportRoute;
var _kibana_services = require("../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function callInitializeImportRoute({
  index,
  settings,
  mappings,
  ingestPipelines,
  existingIndex,
  signal
}) {
  const body = JSON.stringify({
    index,
    settings,
    mappings,
    ingestPipelines,
    existingIndex
  });
  return (0, _kibana_services.getHttp)().fetch({
    path: `/internal/file_upload/initialize_import`,
    method: 'POST',
    version: '1',
    body,
    signal
  });
}
function callImportRoute({
  index,
  data,
  ingestPipelineId,
  signal
}) {
  const body = JSON.stringify({
    index,
    ingestPipelineId,
    data
  });
  return (0, _kibana_services.getHttp)().fetch({
    path: `/internal/file_upload/import`,
    method: 'POST',
    version: '2',
    body,
    signal
  });
}