"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ecs = require("@elastic/ecs");
var _otelSemanticConventions = require("@kbn/otel-semantic-conventions");
var _fields_metadata_client = require("./fields_metadata_client");
var _ecs_fields_repository = require("./repositories/ecs_fields_repository");
var _integration_fields_repository = require("./repositories/integration_fields_repository");
var _metadata_fields_repository = require("./repositories/metadata_fields_repository");
var _otel_fields_repository = require("./repositories/otel_fields_repository");
var _metadata_fields = require("../../../common/metadata_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataService {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "integrationFieldsExtractor", () => Promise.resolve({}));
    (0, _defineProperty2.default)(this, "integrationListExtractor", () => Promise.resolve([]));
    this.logger = logger;
  }
  setup() {
    return {
      registerIntegrationFieldsExtractor: extractor => {
        this.integrationFieldsExtractor = extractor;
      },
      registerIntegrationListExtractor: extractor => {
        this.integrationListExtractor = extractor;
      }
    };
  }
  start(core) {
    const {
      logger,
      integrationFieldsExtractor,
      integrationListExtractor
    } = this;
    const ecsFieldsRepository = _ecs_fields_repository.EcsFieldsRepository.create({
      ecsFields: _ecs.EcsFlat
    });
    const metadataFieldsRepository = _metadata_fields_repository.MetadataFieldsRepository.create({
      metadataFields: _metadata_fields.MetadataFields
    });
    const integrationFieldsRepository = _integration_fields_repository.IntegrationFieldsRepository.create({
      integrationFieldsExtractor,
      integrationListExtractor
    });
    const otelFieldsRepository = _otel_fields_repository.OtelFieldsRepository.create({
      otelFields: _otelSemanticConventions.semconvFlat
    });
    return {
      getClient: async request => {
        const {
          fleet,
          fleetv2
        } = await core.capabilities.resolveCapabilities(request, {
          capabilityPath: '*'
        });
        return _fields_metadata_client.FieldsMetadataClient.create({
          capabilities: {
            fleet,
            fleetv2
          },
          logger,
          ecsFieldsRepository,
          metadataFieldsRepository,
          integrationFieldsRepository,
          otelFieldsRepository
        });
      }
    };
  }
}
exports.FieldsMetadataService = FieldsMetadataService;