"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paletteService = exports.dateHistogramLayer = exports.dateHistogramData = exports.chartsThemeService = exports.chartsActiveCursorService = void 0;
exports.sampleArgsWithReferenceLine = sampleArgsWithReferenceLine;
var _charts = require("@elastic/charts");
var _mocks = require("@kbn/charts-plugin/public/mocks");
var _constants = require("../../common/constants");
var _test_utils = require("../../common/test_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const chartSetupContract = _mocks.chartPluginMock.createSetupContract();
const chartStartContract = _mocks.chartPluginMock.createStartContract();
const chartsThemeService = exports.chartsThemeService = chartSetupContract.theme;
const chartsActiveCursorService = exports.chartsActiveCursorService = chartStartContract.activeCursor;
const paletteService = exports.paletteService = _mocks.chartPluginMock.createPaletteRegistry();
const dateHistogramData = exports.dateHistogramData = {
  type: 'datatable',
  rows: [{
    xAccessorId: 1585758120000,
    splitAccessorId: "Men's Clothing",
    yAccessorId: 1
  }, {
    xAccessorId: 1585758360000,
    splitAccessorId: "Women's Accessories",
    yAccessorId: 1
  }, {
    xAccessorId: 1585758360000,
    splitAccessorId: "Women's Clothing",
    yAccessorId: 1
  }, {
    xAccessorId: 1585759380000,
    splitAccessorId: "Men's Clothing",
    yAccessorId: 1
  }, {
    xAccessorId: 1585759380000,
    splitAccessorId: "Men's Shoes",
    yAccessorId: 1
  }, {
    xAccessorId: 1585759380000,
    splitAccessorId: "Women's Clothing",
    yAccessorId: 1
  }, {
    xAccessorId: 1585760700000,
    splitAccessorId: "Men's Clothing",
    yAccessorId: 1
  }, {
    xAccessorId: 1585760760000,
    splitAccessorId: "Men's Clothing",
    yAccessorId: 1
  }, {
    xAccessorId: 1585760760000,
    splitAccessorId: "Men's Shoes",
    yAccessorId: 1
  }, {
    xAccessorId: 1585761120000,
    splitAccessorId: "Men's Shoes",
    yAccessorId: 1
  }],
  columns: [{
    id: 'xAccessorId',
    name: 'order_date per minute',
    meta: {
      type: 'date',
      field: 'order_date',
      source: 'esaggs',
      index: 'indexPatternId',
      sourceParams: {
        indexPatternId: 'indexPatternId',
        type: 'date_histogram',
        appliedTimeRange: {
          from: '2020-04-01T16:14:16.246Z',
          to: '2020-04-01T17:15:41.263Z'
        },
        params: {
          field: 'order_date',
          timeRange: {
            from: '2020-04-01T16:14:16.246Z',
            to: '2020-04-01T17:15:41.263Z'
          },
          useNormalizedEsInterval: true,
          scaleMetricValues: false,
          interval: '1m',
          drop_partials: false,
          min_doc_count: 0,
          extended_bounds: {}
        }
      },
      params: {
        id: 'date',
        params: {
          pattern: 'HH:mm'
        }
      }
    }
  }, {
    id: 'splitAccessorId',
    name: 'Top values of category.keyword',
    meta: {
      type: 'string',
      field: 'category.keyword',
      source: 'esaggs',
      index: 'indexPatternId',
      sourceParams: {
        indexPatternId: 'indexPatternId',
        type: 'terms',
        params: {
          field: 'category.keyword',
          orderBy: 'yAccessorId',
          order: 'desc',
          size: 3,
          otherBucket: false,
          otherBucketLabel: 'Other',
          missingBucket: false,
          missingBucketLabel: 'Missing'
        }
      },
      params: {
        id: 'terms',
        params: {
          id: 'string',
          otherBucketLabel: 'Other',
          missingBucketLabel: 'Missing',
          parsedUrl: {
            origin: 'http://localhost:5601',
            pathname: '/jiy/app/kibana',
            basePath: '/jiy'
          }
        }
      }
    }
  }, {
    id: 'yAccessorId',
    name: 'Count of records',
    meta: {
      type: 'number',
      source: 'esaggs',
      index: 'indexPatternId',
      sourceParams: {
        indexPatternId: 'indexPatternId',
        params: {}
      },
      params: {
        id: 'number'
      }
    }
  }]
};
const dateHistogramLayer = exports.dateHistogramLayer = {
  layerId: 'dateHistogramLayer',
  type: 'dataLayer',
  layerType: _constants.LayerTypes.DATA,
  showLines: true,
  simpleView: false,
  xAccessor: 'xAccessorId',
  xScaleType: 'time',
  isHistogram: true,
  isStacked: true,
  isPercentage: false,
  isHorizontal: false,
  splitAccessors: ['splitAccessorId'],
  seriesType: 'bar',
  accessors: ['yAccessorId'],
  palette: _test_utils.mockPaletteOutput,
  table: dateHistogramData
};
function sampleArgsWithReferenceLine(value = 150) {
  const {
    args: sArgs
  } = (0, _test_utils.sampleArgs)();
  const data = {
    type: 'datatable',
    columns: [{
      id: 'referenceLine-a',
      meta: {
        params: {
          id: 'number'
        },
        type: 'number'
      },
      name: 'Static value'
    }],
    rows: [{
      'referenceLine-a': value
    }]
  };
  const args = {
    ...sArgs,
    layers: [...sArgs.layers, {
      layerId: 'referenceLine-a',
      type: 'referenceLineLayer',
      layerType: _constants.LayerTypes.REFERENCELINE,
      accessors: ['referenceLine-a'],
      decorations: [{
        forAccessor: 'referenceLine-a',
        type: 'referenceLineDecorationConfig',
        position: _charts.Position.Left
      }],
      table: data
    }]
  };
  return {
    data,
    args
  };
}