"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromQuery = fromQuery;
exports.toQuery = toQuery;
var _queryString = require("query-string");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toQuery(search) {
  return search ? (0, _queryString.parse)(search.slice(1), {
    sort: false
  }) : {};
}
function fromQuery(query) {
  const encodedQuery = _public.url.encodeQuery(query, value => encodeURIComponent(value).replace(/%3A/g, ':'));
  return (0, _queryString.stringify)(encodedQuery, {
    sort: false,
    encode: false
  });
}