"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlFieldTypes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal **/

/**
 * All supported field types in ES|QL. This is all the types
 * that can come back in the table from a query.
 */
const esqlFieldTypes = exports.esqlFieldTypes = ['boolean', 'date', 'double', 'ip', 'keyword', 'integer', 'long', 'text', 'unsigned_long', 'version', 'cartesian_point', 'cartesian_shape', 'geo_point', 'geo_shape', 'counter_integer', 'counter_long', 'counter_double', 'unsupported', 'date_nanos', 'function_named_parameters', 'aggregate_metric_double', 'dense_vector', 'histogram', 'exponential_histogram', 'tdigest'];

/**
 *  Partial fields metadata client, used to avoid circular dependency with @kbn/monaco
 **/