"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromQLParser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
var _promql_lexer = _interopRequireDefault(require("../../parser/antlr/promql_lexer"));
var _promql_parser = _interopRequireDefault(require("../../parser/antlr/promql_parser"));
var _promql_error_listener = require("./promql_error_listener");
var _cst_to_ast_converter = require("./cst_to_ast_converter");
var _builder = require("../builder");
var _PromQLParser;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Parser for PromQL queries.
 *
 * This parser transforms PromQL source text into an Abstract Syntax Tree (AST)
 * that can be used for analysis, validation, and transformation.
 */
class PromQLParser {
  constructor(src, options = {}) {
    (0, _defineProperty2.default)(this, "streams", void 0);
    (0, _defineProperty2.default)(this, "lexer", void 0);
    (0, _defineProperty2.default)(this, "tokens", void 0);
    (0, _defineProperty2.default)(this, "parser", void 0);
    (0, _defineProperty2.default)(this, "errors", new _promql_error_listener.PromQLErrorListener());
    this.src = src;
    this.options = options;
    const streams = this.streams = _antlr.CharStreams.fromString(src);
    const lexer = this.lexer = new _promql_lexer.default(streams);
    const tokens = this.tokens = new _antlr.CommonTokenStream(lexer);
    const parser = this.parser = new _promql_parser.default(tokens);
    lexer.removeErrorListeners();
    lexer.addErrorListener(this.errors);
    parser.removeErrorListeners();
    parser.addErrorListener(this.errors);
  }

  /**
   * Parse the source text and return the AST.
   */
  parse() {
    try {
      const ctx = this.parser.singleStatement();
      const converter = new _cst_to_ast_converter.PromQLCstToAstConverter(this);
      const root = converter.fromSingleStatement(ctx);
      if (!root) {
        return {
          root: _builder.PromQLBuilder.expression.query(undefined, {
            incomplete: true
          }),
          errors: this.errors.getErrors()
        };
      }
      return {
        root,
        errors: this.errors.getErrors()
      };
    } catch (error) {
      const root = _builder.PromQLBuilder.expression.query(undefined, {
        incomplete: true
      });
      return {
        root,
        errors: this.errors.getErrors()
      };
    }
  }

  /**
   * Parse the source text and return only the errors.
   */
  parseErrors() {
    this.parser.singleStatement();
    return this.errors.getErrors();
  }
}
exports.PromQLParser = PromQLParser;
_PromQLParser = PromQLParser;
/**
 * Create a new PromQL parser instance.
 */
(0, _defineProperty2.default)(PromQLParser, "create", (src, options) => {
  return new _PromQLParser(src, options);
});
/**
 * Parse a complete PromQL query, generating an AST and a list of parsing errors.
 *
 * Make sure to check the returned `errors` list for any parsing issues.
 *
 * For example:
 *
 * ```typescript
 * const result = PromQLParser.parse('rate(http_requests_total[5m])');
 * ```
 *
 * @param src Source text to parse.
 * @param options Parsing options.
 */
(0, _defineProperty2.default)(PromQLParser, "parse", (src, options) => {
  return _PromQLParser.create(src, options).parse();
});
/**
 * Extract parsing errors from the source text without generating an AST.
 *
 * @param src Source text to parse for errors.
 * @returns A list of parsing errors.
 */
(0, _defineProperty2.default)(PromQLParser, "parseErrors", src => {
  return _PromQLParser.create(src).parseErrors();
});