"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrievePolicies = retrievePolicies;
exports.retrieveSources = retrieveSources;
var _ast = require("../../ast");
var _resources_helpers = require("../shared/resources_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createMapFromList(arr) {
  const arrMap = new Map();
  for (const item of arr) {
    arrMap.set(item.name, item);
  }
  return arrMap;
}
async function retrievePolicies(commands, callbacks) {
  const enrichCommands = _ast.Walker.matchAll(commands, {
    type: 'command',
    name: 'enrich'
  });
  if (!callbacks || !enrichCommands.length) {
    return new Map();
  }
  const policies = await (0, _resources_helpers.getPolicyHelper)(callbacks).getPolicies();
  return createMapFromList(policies);
}
async function retrieveSources(commands, callbacks) {
  if (!callbacks || commands.length < 1) {
    return new Set();
  }
  if (['row', 'show', 'meta'].includes(commands[0].name)) {
    return new Set();
  }
  const sources = await (0, _resources_helpers.getSourcesHelper)(callbacks)();
  return new Set(sources.map(({
    name
  }) => name));
}