"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SynthNode = void 0;
var _walker = require("../../ast/walker");
var _builder = require("../../ast/builder");
var _pretty_print = require("../../pretty_print");
var _debug = require("../../shared/debug");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This is used as a prototype of AST nodes created by the synth methods.
 * It implements the `toString` method, which is invoked when the node is
 * coerced to a string. So you can easily convert the node to a string by
 * calling `String(node)` or `${node}`:
 *
 * ```js
 * const node = expr`a.b`;  // { type: 'column', name: 'a.b' }
 * String(node)             // 'a.b'
 * ```
 */
class SynthNode {
  static from(node) {
    // Remove parser generated fields.
    _walker.Walker.walk(node, {
      visitAny: n => {
        Object.assign(n, _builder.Builder.parserFields({}));
      }
    });
    node = Object.assign(new SynthNode(), node);
    return node;
  }
  toString() {
    return _pretty_print.BasicPrettyPrinter.print(this);
  }
  dump(options) {
    return (0, _debug.printAst)(this, {
      location: false,
      ...options
    });
  }
}
exports.SynthNode = SynthNode;