"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
var _uniqBy = _interopRequireDefault(require("lodash/uniqBy"));
var _is = require("../../../ast/is");
var _utils = require("../../definitions/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getUserDefinedColumns = (command, typeOf, query) => {
  const columns = [];
  for (const expression of command.args) {
    if ((0, _is.isAssignment)(expression) && (0, _is.isColumn)(expression.args[0])) {
      const name = expression.args[0].parts.join('.');
      const newColumn = {
        name,
        type: typeOf(expression.args[1]),
        location: expression.args[0].location,
        userDefined: true
      };
      columns.push(newColumn);
      continue;
    }
    if ((0, _is.isOptionNode)(expression) && expression.name === 'by') {
      columns.push(...getUserDefinedColumns(expression, typeOf, query));
      continue;
    }
    if ((0, _is.isFunctionExpression)(expression) && expression.name === 'where') {
      const assignment = expression.args[0];
      if ((0, _is.isAssignment)(assignment) && (0, _is.isColumn)(assignment.args[0])) {
        const name = assignment.args[0].parts.join('.');
        const newColumn = {
          name,
          type: typeOf(assignment.args[1]),
          location: assignment.args[0].location,
          userDefined: true
        };
        columns.push(newColumn);
      }
      continue;
    }
    if ((0, _is.isColumn)(expression)) {
      const name = expression.parts.join('.');
      const newColumn = {
        name,
        type: typeOf(expression),
        location: expression.location,
        userDefined: true
      };
      columns.push(newColumn);
      continue;
    }
    if (!(0, _is.isOptionNode)(expression) && !Array.isArray(expression)) {
      const newColumn = {
        name: query.substring(expression.location.min, expression.location.max + 1),
        type: typeOf(expression),
        location: expression.location,
        userDefined: true
      };
      columns.push(newColumn);
      continue;
    }
  }
  return columns;
};
const columnsAfter = (command, previousColumns, query) => {
  const columnMap = new Map();
  previousColumns.forEach(col => columnMap.set(col.name, col)); // TODO make this more efficient

  const typeOf = thing => (0, _utils.getExpressionType)(thing, columnMap);
  return (0, _uniqBy.default)([...getUserDefinedColumns(command, typeOf, query)], 'name');
};
exports.columnsAfter = columnsAfter;