"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sampleCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const sampleCommandMethods = {
  autocomplete: _autocomplete.autocomplete
};
const sampleCommand = exports.sampleCommand = {
  name: 'sample',
  methods: sampleCommandMethods,
  metadata: {
    preview: true,
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.sampleDoc', {
      defaultMessage: 'Samples a percentage of the results, optionally with a seed for reproducibility.'
    }),
    declaration: `SAMPLE <percentage>`,
    examples: [`FROM employees
| KEEP emp_no
| SAMPLE 0.05,`]
  }
};