"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _complete_items = require("../complete_items");
var _literals = require("../../definitions/utils/literals");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  const innerText = query.substring(0, cursorPosition);
  if (/[0-9]\s+$/.test(innerText)) {
    return [_complete_items.pipeCompleteItem];
  }
  return (0, _literals.buildConstantsDefinitions)(['10', '100', '1000'], '', undefined, {
    advanceCursorAndOpenSuggestions: true
  });
}