"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _helpers = require("../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../complete_items");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _await$callbacks$getB, _callbacks$getByType;
  const innerText = query.substring(0, cursorPosition);
  if (/\s/.test(innerText[innerText.length - 1]) && (0, _helpers.getLastNonWhitespaceChar)(innerText) !== ',' && !/keep\s+\S*$/i.test(innerText)) {
    return [_complete_items.pipeCompleteItem, _complete_items.commaCompleteItem];
  }
  const alreadyDeclaredFields = command.args.filter(_is.isColumn).map(arg => arg.parts.join('.'));
  const fieldSuggestions = (_await$callbacks$getB = await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, 'any', alreadyDeclaredFields))) !== null && _await$callbacks$getB !== void 0 ? _await$callbacks$getB : [];
  return (0, _helpers.handleFragment)(innerText, fragment => (0, _helpers.columnExists)(fragment, context), (_fragment, rangeToReplace) => {
    // KEEP fie<suggest>
    return fieldSuggestions.map(suggestion => {
      return (0, _helpers.withAutoSuggest)({
        ...suggestion,
        text: suggestion.text,
        rangeToReplace
      });
    });
  }, (fragment, rangeToReplace) => {
    // KEEP field<suggest>
    const finalSuggestions = [{
      ..._complete_items.pipeCompleteItem,
      text: ' | '
    }];
    if (fieldSuggestions.length > 0) finalSuggestions.push({
      ..._complete_items.commaCompleteItem,
      text: ', '
    });
    return finalSuggestions.map(s => (0, _helpers.withAutoSuggest)({
      ...s,
      filterText: fragment,
      text: fragment + s.text,
      rangeToReplace
    }));
  });
}