"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../definitions/utils/autocomplete/helpers");
var _autocomplete = require("../stats/autocomplete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  if (!(callbacks !== null && callbacks !== void 0 && callbacks.getByType) || !(callbacks !== null && callbacks !== void 0 && callbacks.getColumnsForQuery)) {
    return [];
  }
  const innerText = query.substring(0, cursorPosition);
  const commandText = innerText.slice(command.location.min);
  const currentInput = commandText.toUpperCase();
  const afterInlineMatch = currentInput.match(/^INLINE\s+(.*)$/);

  // If user typed "INLINE " + partial STATS, suggest STATS (check this first)
  if (afterInlineMatch) {
    const afterInline = afterInlineMatch[1];
    if ('STATS'.startsWith(afterInline) && afterInline.length <= 'INLINE'.length) {
      return [(0, _helpers.withAutoSuggest)({
        label: 'STATS',
        text: 'STATS ',
        kind: 'Keyword',
        detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.inlineStats.statsKeyword', {
          defaultMessage: 'STATS keyword'
        }),
        sortText: 'A'
      })];
    }
  }

  // If user typed something that could become INLINE, suggest INLINE STATS
  const trimmedInput = currentInput.trim();
  if ('INLINE'.startsWith(trimmedInput) && trimmedInput.length <= 'INLINE'.length) {
    return [(0, _helpers.withAutoSuggest)({
      label: 'INLINE STATS',
      text: 'INLINE STATS ',
      kind: 'Keyword',
      detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.inlineStats.commandSuggestion', {
        defaultMessage: 'INLINE STATS command'
      }),
      sortText: 'A'
    })];
  }

  // case "INLINE STATS" or "INLINE (...more spaces) STATS "
  const hasCompleteInlineStats = /^INLINE\s+STATS(\s|$)/.test(currentInput);
  if (hasCompleteInlineStats) {
    return (0, _autocomplete.autocomplete)(query, command, callbacks, context, cursorPosition);
  }
  return [];
}