"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../complete_items");
var _literals = require("../../definitions/utils/literals");
var _types = require("../../definitions/types");
var _parser = require("../../../parser");
var _ast = require("../../definitions/utils/ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition = query.length) {
  const innerText = query.substring(0, cursorPosition);
  const commandArgs = command.args.filter(arg => !Array.isArray(arg) && arg.type !== 'unknown');

  // If cursor is inside a string literal, don't suggest anything
  const correctedQuery = (0, _ast.correctQuerySyntax)(innerText);
  const {
    root
  } = _parser.Parser.parse(correctedQuery, {
    withFormatting: true
  });
  const {
    node
  } = (0, _ast.findAstPosition)(root, innerText.length);
  if ((node === null || node === void 0 ? void 0 : node.type) === 'literal' && node.literalType === 'keyword') {
    return [];
  }
  const hasField = commandArgs.length >= 1;
  const hasPatterns = commandArgs.length >= 2;
  const endsWithSpace = /\s$/.test(innerText);
  const endsWithComma = /,\s*$/.test(innerText);

  // No field yet OR still typing field name (no patterns and no trailing space) - suggest field names
  if (!hasField || hasField && !hasPatterns && !endsWithSpace) {
    var _callbacks$getByType;
    const fieldSuggestions = (await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, _types.ESQL_STRING_TYPES))) || [];
    return fieldSuggestions.map(suggestion => ({
      ...(0, _helpers.withAutoSuggest)(suggestion),
      text: `${suggestion.text} `
    }));
  }
  if (hasField && !hasPatterns && endsWithSpace) {
    return (0, _literals.buildConstantsDefinitions)(['"%{WORD:firstWord}"'], _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.aPatternString', {
      defaultMessage: 'A pattern string'
    }), undefined, {
      advanceCursorAndOpenSuggestions: true
    });
  }
  if (endsWithComma) {
    return (0, _literals.buildConstantsDefinitions)(['"%{WORD:nextWord}"'], _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.aPatternString', {
      defaultMessage: 'A pattern string'
    }), undefined, {
      advanceCursorAndOpenSuggestions: true
    });
  }

  // Has at least one pattern - suggest pipe or comma for more patterns
  if (hasPatterns) {
    return [(0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem), (0, _helpers.withAutoSuggest)({
      ..._complete_items.commaCompleteItem,
      text: ', '
    })];
  }
  return [];
}