"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
exports.extractDissectColumnNames = extractDissectColumnNames;
var _walker = require("../../../ast/walker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function unquoteTemplate(inputString) {
  if (inputString.startsWith('"') && inputString.endsWith('"') && inputString.length >= 2) {
    return inputString.substring(1, inputString.length - 1);
  }
  return inputString;
}
function extractDissectColumnNames(pattern) {
  const regex = /%\{(?:[?+]?)?([^}]+?)(?:->)?\}/g;
  const matches = pattern.matchAll(regex);
  const columns = [];
  for (const match of matches) {
    if (match && match[1]) {
      const columnName = match[1];
      if (!columns.includes(columnName)) {
        columns.push(columnName);
      }
    }
  }
  return columns;
}
const columnsAfter = (command, previousColumns, query) => {
  const columns = [];
  (0, _walker.walk)(command, {
    visitLiteral: node => {
      const dissectPattern = unquoteTemplate(String(node.value));
      columns.push(...extractDissectColumnNames(dissectPattern));
    }
  });
  return [...previousColumns, ...columns.map(column => {
    const newColumn = {
      name: column,
      type: 'keyword',
      userDefined: false
    };
    return newColumn;
  })];
};
exports.columnsAfter = columnsAfter;