"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateCommandArguments = void 0;
var _is = require("../../../../ast/is");
var _function = require("./function");
var _option = require("./option");
var _column = require("./column");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validateCommandArguments = (command, ast, context = {
  columns: new Map() // Ensure context is always defined
}, callbacks = {}) => {
  const messages = [];
  for (const arg of command.args) {
    if (!Array.isArray(arg)) {
      if ((0, _is.isFunctionExpression)(arg)) {
        messages.push(...(0, _function.validateFunction)({
          fn: arg,
          parentCommand: command,
          ast,
          context,
          callbacks
        }));
      } else if ((0, _is.isOptionNode)(arg)) {
        messages.push(...(0, _option.validateOption)(arg, command, ast, context, callbacks));
      } else if ((0, _is.isColumn)(arg) || (0, _is.isIdentifier)(arg)) {
        if (command.name === 'stats' || command.name === 'inline stats') {
          messages.push(_errors.errors.unknownAggFunction(arg));
        } else {
          messages.push(...(0, _column.validateColumnForCommand)(arg, command.name, context));
        }
      }
    }
  }
  return messages;
};
exports.validateCommandArguments = validateCommandArguments;