"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOperatorSuggestion = getOperatorSuggestion;
exports.getOperatorSuggestions = void 0;
var _helpers = require("./autocomplete/helpers");
var _all_operators = require("../all_operators");
var _functions = require("./functions");
var _test_functions = require("./test_functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getOperatorSuggestion(fn) {
  const hasArgs = fn.signatures.some(({
    params
  }) => params.length > 1);
  const suggestion = {
    label: fn.name.toUpperCase(),
    text: hasArgs ? `${fn.name.toUpperCase()} $0` : fn.name.toUpperCase(),
    asSnippet: hasArgs,
    kind: 'Operator',
    documentation: {
      value: fn.description
    },
    sortText: 'D'
  };
  return hasArgs ? (0, _helpers.withAutoSuggest)(suggestion) : suggestion;
}

/**
 * Builds suggestions for operators based on the provided predicates.
 *
 * @param predicates a set of conditions that must be met for an operator to be included in the suggestions
 * @returns
 */
const getOperatorSuggestions = (predicates, hasMinimumLicenseRequired, activeProduct) => {
  const filteredDefinitions = (0, _functions.filterFunctionDefinitions)((0, _test_functions.getTestFunctions)().length ? [..._all_operators.operatorsDefinitions, ...(0, _test_functions.getTestFunctions)()] : _all_operators.operatorsDefinitions, predicates, hasMinimumLicenseRequired, activeProduct);

  // make sure the operator has at least one signature that matches
  // the type of the existing left argument if provided (e.g. "doubleField <suggest>")
  return (predicates !== null && predicates !== void 0 && predicates.leftParamType ? filteredDefinitions.filter(({
    signatures
  }) => signatures.some(({
    params
  }) => !params.length || params.some(pArg => pArg.type === (predicates === null || predicates === void 0 ? void 0 : predicates.leftParamType) || pArg.type === 'any'))) : filteredDefinitions).map(getOperatorSuggestion);
};
exports.getOperatorSuggestions = getOperatorSuggestions;