"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NOT_IN_REGEX = exports.LIKE_OPERATOR_REGEX = exports.IS_NULL_OPERATOR_REGEX = exports.IS_NOT_REGEX = exports.IN_OPERATOR_REGEX = void 0;
exports.endsWithInOrNotInToken = endsWithInOrNotInToken;
exports.endsWithIsOrIsNotToken = endsWithIsOrIsNotToken;
exports.endsWithLikeOrRlikeToken = endsWithLikeOrRlikeToken;
exports.getLogicalContinuationSuggestions = getLogicalContinuationSuggestions;
exports.isOperandMissing = isOperandMissing;
exports.shouldSuggestOpenListForOperand = shouldSuggestOpenListForOperand;
var _is = require("../../../../../../ast/is");
var _ast = require("../../../ast");
var _operators = require("../../../operators");
var _all_operators = require("../../../../all_operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LIKE_OPERATOR_REGEX = exports.LIKE_OPERATOR_REGEX = /\b(not\s+)?(r?like)\s*$/i;
const IS_NOT_REGEX = exports.IS_NOT_REGEX = /\bis\s+not\b/i;
const IS_NULL_OPERATOR_REGEX = exports.IS_NULL_OPERATOR_REGEX = /\bis\s+(?:n(?:o(?:t(?:\s+n(?:u(?:l)?)?|\s*)?)?|u(?:l)?)?)?$/i;
const IN_OPERATOR_REGEX = exports.IN_OPERATOR_REGEX = /\b(?:not\s+)?in\s*\(?\s*$/i;
const NOT_IN_REGEX = exports.NOT_IN_REGEX = /\bnot\s+in\s*$/i;
function endsWithInOrNotInToken(innerText) {
  return IN_OPERATOR_REGEX.test(innerText);
}
function endsWithLikeOrRlikeToken(innerText) {
  return LIKE_OPERATOR_REGEX.test(innerText);
}
function endsWithIsOrIsNotToken(innerText) {
  return IS_NULL_OPERATOR_REGEX.test(innerText);
}
function isOperandMissing(operand) {
  return !operand || (0, _ast.isMarkerNode)(operand) || (operand === null || operand === void 0 ? void 0 : operand.type) === 'unknown' && (operand === null || operand === void 0 ? void 0 : operand.incomplete) === true;
}

/** Returns true if we should suggest opening a list for the right operand */
function shouldSuggestOpenListForOperand(operand) {
  return isOperandMissing(operand) || (0, _is.isList)(operand) && operand.location.min === 0 && operand.location.max === 0;
}

/** Suggestions for logical continuations after a complete list or null-check operator */
function getLogicalContinuationSuggestions() {
  return _all_operators.logicalOperators.map(_operators.getOperatorSuggestion);
}