"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPhrasesFilter = exports.getPhrasesFilterField = exports.buildPhrasesFilter = void 0;
var _types = require("./types");
var _phrase_filter = require("./phrase_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @param filter
 * @returns `true` if a filter is a `PhrasesFilter`
 *
 * @public
 */
const isPhrasesFilter = filter => {
  var _filter$meta;
  return (filter === null || filter === void 0 ? void 0 : (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.type) === _types.FILTERS.PHRASES;
};

/** @internal */
exports.isPhrasesFilter = isPhrasesFilter;
const getPhrasesFilterField = filter => {
  // Phrases is a newer filter type that has always been created via a constructor that ensures
  // `meta.key` is set to the field name
  return filter.meta.key;
};

/**
 * Creates a filter where the given field matches one or more of the given values
 * params should be an array of values
 * @param field
 * @param params
 * @param indexPattern
 * @returns
 *
 * @public
 */
exports.getPhrasesFilterField = getPhrasesFilterField;
const buildPhrasesFilter = (field, params, indexPattern) => {
  const index = indexPattern.id;
  const type = _types.FILTERS.PHRASES;
  const key = field.name;
  let should;
  if (field.scripted) {
    should = params.map(v => ({
      script: (0, _phrase_filter.getPhraseScript)(field, v)
    }));
  } else {
    should = params.map(v => ({
      match_phrase: {
        [field.name]: v
      }
    }));
  }
  return {
    meta: {
      index,
      type,
      key,
      params
    },
    query: {
      bool: {
        should,
        minimum_should_match: 1
      }
    }
  };
};
exports.buildPhrasesFilter = buildPhrasesFilter;