"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildFilter = buildFilter;
var _phrase_filter = require("./phrase_filter");
var _phrases_filter = require("./phrases_filter");
var _range_filter = require("./range_filter");
var _exists_filter = require("./exists_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 *
 * @param indexPattern
 * @param field
 * @param type
 * @param negate whether the filter is negated (NOT filter)
 * @param disabled  whether the filter is disabled andwon't be applied to searches
 * @param params
 * @param alias a display name for the filter
 * @param store whether the filter applies to the current application or should be applied to global context
 * @returns
 *
 * @public
 */
function buildFilter(indexPattern, field, type, negate, disabled, params, alias, store) {
  const filter = buildBaseFilter(indexPattern, field, type, params);
  filter.meta.alias = alias;
  filter.meta.negate = negate;
  filter.meta.disabled = disabled;
  if (store) {
    filter.$state = {
      store
    };
  }
  return filter;
}
function buildBaseFilter(indexPattern, field, type, params) {
  switch (type) {
    case 'phrase':
      return (0, _phrase_filter.buildPhraseFilter)(field, params, indexPattern);
    case 'phrases':
      return (0, _phrases_filter.buildPhrasesFilter)(field, params, indexPattern);
    case 'range':
      const {
        from: gte,
        to: lt
      } = params;
      return (0, _range_filter.buildRangeFilter)(field, {
        lt,
        gte
      }, indexPattern);
    case 'range_from_value':
      return (0, _range_filter.buildRangeFilter)(field, params, indexPattern);
    case 'exists':
      return (0, _exists_filter.buildExistsFilter)(field, indexPattern);
    default:
      throw new Error(`Unknown filter type: ${type}`);
  }
}