"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testDefinitionIsSubset = exports.testDefinitionIsExact = exports.testDefinitionHasIncompatibleFields = exports.testDefinitionHasExtraFields = exports.testDefinitionHasExcessAndMissingFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Test: Definition has exactly all the fields in the full document fields

// Test: Should succeed. Exact match between definition and document fields

const testDefinitionIsExact = exports.testDefinitionIsExact = true;

// Test: Definition has a subset of the fields in the full document fields

// Test: Should succeed. Definition is a subset of the full document fields

const testDefinitionIsSubset = exports.testDefinitionIsSubset = true;

// Test: Definition has extra fields not in the full document fields

// Test: Should fail. Definition has extra fields not in the full document fields

const testDefinitionHasExtraFields = exports.testDefinitionHasExtraFields = [
// @ts-expect-error - createdAt is in the definition, this checks that an error is not thrown for defined keys
Object.assign(new Error(), 'The following keys are missing from the document fields: createdAt'),
// @ts-expect-error - Unknown Key is not in the definition, this checks that an error is thrown for the unknown key
Object.assign(new Error(), 'The following keys are missing from the document fields: Unknown Key'),
// This checks that an error is thrown for the missing keys
Object.assign(new Error(), 'The following keys are missing from the document fields: definedButNotInDocOne'), Object.assign(new Error(), 'The following keys are missing from the document fields: definedButNotInDocTwo')];

// Test: Definition has extra fields and missing fields compared to full document fields

// Test: Should fail. Definition has extra fields and missing fields compared to full document fields

const testDefinitionHasExcessAndMissingFields = exports.testDefinitionHasExcessAndMissingFields = [
// @ts-expect-error - createdAt is in the definition, this checks that an error is not thrown for defined keys
Object.assign(new Error(), 'The following keys are missing from the document fields: name'),
// @ts-expect-error - createdAt is in the definition, this checks that an error is not thrown for defined keys
Object.assign(new Error(), 'The following keys are missing from the document fields: createdAt'),
// @ts-expect-error - Unknown Key is not in the definition, this checks that an error is thrown for the unknown key
Object.assign(new Error(), 'The following keys are missing from the document fields: Unknown Key'),
// This checks that an error is thrown for the missing keys
Object.assign(new Error(), 'The following keys are missing from the document fields: definedButNotInDocOne'), Object.assign(new Error(), 'The following keys are missing from the document fields: definedButNotInDocTwo')];

// Test: Definition has incompatible fields with full document fields

// type never because the definition has incompatible fields with the full document fields
let testDefinitionHasIncompatibleFields = exports.testDefinitionHasIncompatibleFields = void 0;