"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAnalyticsCollectionDataViewId = void 0;
var _fetch_analytics_collection = require("./fetch_analytics_collection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAnalyticsCollectionDataViewId = async (elasticsearchClient, dataViewsService, collectionName) => {
  var _collectionDataView$;
  const collections = await (0, _fetch_analytics_collection.fetchAnalyticsCollections)(elasticsearchClient, collectionName);
  const collectionDataView = await dataViewsService.find(collections[0].events_datastream, 1);
  return {
    data_view_id: (collectionDataView === null || collectionDataView === void 0 ? void 0 : (_collectionDataView$ = collectionDataView[0]) === null || _collectionDataView$ === void 0 ? void 0 : _collectionDataView$.id) || null
  };
};
exports.fetchAnalyticsCollectionDataViewId = fetchAnalyticsCollectionDataViewId;