"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasConnectors: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasDefaultIngestPipeline: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasDocumentLevelSecurityEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasIncrementalSyncEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasNativeConnectors: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasWebCrawler: _configSchema.schema.boolean({
    defaultValue: false
  })
});
const config = exports.config = {
  deprecations: ({
    renameFromRoot
  }) => [renameFromRoot('enterpriseSearch.enabled', 'xpack.search.enabled', {
    level: 'critical'
  }), renameFromRoot('enterpriseSearch.hasConnectors', 'xpack.search.hasConnectors', {
    level: 'critical'
  }), renameFromRoot('enterpriseSearch.hasDefaultIngestPipeline', 'xpack.search.hasDefaultIngestPipeline', {
    level: 'critical'
  }), renameFromRoot('enterpriseSearch.hasDocumentLevelSecurityEnabled', 'xpack.search.hasDocumentLevelSecurityEnabled', {
    level: 'critical'
  }), renameFromRoot('enterpriseSearch.hasIncrementalSyncEnabled', 'xpack.search.hasIncrementalSyncEnabled', {
    level: 'critical'
  }), renameFromRoot('enterpriseSearch.hasNativeConnectors', 'xpack.search.hasNativeConnectors', {
    level: 'critical'
  }), renameFromRoot('enterpriseSearch.hasWebCrawler', 'xpack.search.hasWebCrawler', {
    level: 'critical'
  })],
  schema: configSchema
};