"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNavigationTreeDefinition = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _deeplinksManagement = require("@kbn/deeplinks-management");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyIconAgents = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/search-shared-ui/src/v2_icons/robot'))).then(m => ({
  default: m.iconRobot
})));
const title = _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.headerSolutionSwitcher.searchSolutionTitle', {
  defaultMessage: 'Elasticsearch'
});
const icon = 'logoElasticsearch';
const getNavigationTreeDefinition = ({
  dynamicItems$,
  isCloudEnabled
}) => {
  return {
    dataTestSubj: 'searchSideNav',
    homePage: _deeplinksSearch.SEARCH_HOMEPAGE,
    icon,
    id: 'es',
    navigationTree$: dynamicItems$.pipe((0, _rxjs.debounceTime)(10), (0, _rxjs.map)(() => {
      const navTree = {
        body: [{
          link: _deeplinksSearch.SEARCH_HOMEPAGE,
          title,
          icon,
          renderAs: 'home'
        }, {
          link: 'discover'
        }, {
          getIsActive: ({
            pathNameSerialized,
            prepend
          }) => {
            return pathNameSerialized.startsWith(prepend('/app/dashboards'));
          },
          link: 'dashboards'
        }, {
          icon: LazyIconAgents,
          link: 'agent_builder'
        }, {
          badgeType: 'techPreview',
          link: 'workflows'
        }, {
          children: [{
            children: [{
              link: 'ml:overview'
            }, {
              link: 'ml:dataVisualizer'
            }],
            id: 'ml_overview',
            title: ''
          }, {
            breadcrumbStatus: 'hidden',
            children: [{
              link: 'ml:anomalyExplorer'
            }, {
              link: 'ml:singleMetricViewer'
            }],
            id: 'category-anomaly_detection',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.machineLearning.anomalyDetection', {
              defaultMessage: 'Anomaly detection'
            })
          }, {
            breadcrumbStatus: 'hidden',
            children: [{
              link: 'ml:resultExplorer'
            }, {
              link: 'ml:analyticsMap'
            }],
            id: 'category-data_frame analytics',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.machineLearning.dataFrameAnalytics', {
              defaultMessage: 'Data frame analytics'
            })
          }, {
            breadcrumbStatus: 'hidden',
            children: [{
              link: 'ml:logRateAnalysis'
            }, {
              link: 'ml:logPatternAnalysis'
            }, {
              link: 'ml:changePointDetections'
            }],
            id: 'category-aiops_labs',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.machineLearning.aiops_labs', {
              defaultMessage: 'AIOps labs'
            })
          }],
          icon: 'machineLearningApp',
          id: 'machine_learning',
          renderAs: 'panelOpener',
          title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.machineLearning', {
            defaultMessage: 'Machine Learning'
          })
        }, {
          children: [{
            children: [{
              getIsActive: ({
                pathNameSerialized,
                prepend
              }) => {
                return pathNameSerialized.startsWith(prepend('/app/elasticsearch/index_management/indices')) || pathNameSerialized.startsWith(prepend('/app/management/data/index_management'));
              },
              link: 'management:index_management'
            }, {
              link: 'management:index_lifecycle_management'
            }, {
              link: 'management:snapshot_restore'
            }, {
              link: 'management:transform'
            }, {
              link: 'management:rollup_jobs'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.ingest.indices.title', {
              defaultMessage: 'Indices and data streams'
            })
          }, {
            children: [{
              link: 'management:ingest_pipelines'
            }, {
              link: 'management:pipelines'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.ingest.pipelines.title', {
              defaultMessage: 'Ingest'
            })
          }, {
            children: [{
              link: 'searchSynonyms:synonyms'
            }, {
              link: 'searchQueryRules'
            }, {
              link: 'searchPlayground'
            }],
            id: 'search_relevance',
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.ingest.relevance.title', {
              defaultMessage: 'Relevance'
            })
          }],
          icon: 'database',
          id: _deeplinksManagement.DATA_MANAGEMENT_NAV_ID,
          renderAs: 'panelOpener',
          title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.dataManagement', {
            defaultMessage: 'Data management'
          })
        }],
        footer: [{
          icon: 'launch',
          id: 'search_getting_started',
          link: 'searchGettingStarted'
        }, {
          getIsActive: ({
            pathNameSerialized,
            prepend
          }) => {
            return pathNameSerialized.startsWith(prepend('/app/dev_tools'));
          },
          icon: 'code',
          id: 'dev_tools',
          link: 'dev_tools',
          title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.devTools', {
            defaultMessage: 'Developer Tools'
          })
        }, {
          icon: 'managementApp',
          children: [{
            children: [{
              // We include this link here to ensure that the settings icon does not land on Stack Monitoring by default
              // https://github.com/elastic/kibana/issues/241518
              // And that the sidenav panel opens when user lands to legacy management landing page
              // https://github.com/elastic/kibana/issues/240275
              link: 'management',
              title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.home', {
                defaultMessage: 'Home'
              }),
              breadcrumbStatus: 'hidden'
            },
            // Only show Cloud Connect in on-prem deployments (not cloud)
            ...(isCloudEnabled ? [] : [{
              id: 'cloud_connect',
              link: 'cloud_connect'
            }]), {
              id: 'monitoring',
              link: 'monitoring'
            }],
            id: 'stack_management_home',
            title: ''
          }, {
            children: [{
              link: 'management:triggersActionsAlerts'
            }, {
              link: 'management:triggersActions'
            }, {
              link: 'management:triggersActionsConnectors'
            }, {
              link: 'management:reporting'
            }, {
              link: 'management:jobsListLink'
            }, {
              link: 'management:watcher'
            }, {
              link: 'management:maintenanceWindows'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.alerts', {
              defaultMessage: 'Alerts and Insights'
            })
          }, {
            children: [{
              link: 'management:trained_models'
            }, {
              link: 'searchInferenceEndpoints:inferenceEndpoints'
            }, {
              link: 'management:anomaly_detection'
            }, {
              link: 'management:analytics'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.machineLearning', {
              defaultMessage: 'Machine Learning'
            })
          }, {
            children: [{
              link: 'management:genAiSettings'
            }, {
              link: 'management:aiAssistantManagementSelection'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.ai', {
              defaultMessage: 'AI'
            })
          }, {
            children: [{
              link: 'management:users'
            }, {
              link: 'management:roles'
            }, {
              link: 'management:api_keys'
            }, {
              link: 'management:role_mappings'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.security', {
              defaultMessage: 'Security'
            })
          }, {
            children: [{
              link: 'management:cross_cluster_replication'
            }, {
              link: 'management:remote_clusters'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.dataV2', {
              defaultMessage: 'Data'
            })
          }, {
            children: [{
              link: 'management:dataViews'
            }, {
              link: 'management:filesManagement'
            }, {
              link: 'visualize'
            }, {
              link: 'management:objects'
            }, {
              link: 'management:tags'
            }, {
              link: 'management:search_sessions'
            }, {
              link: 'management:spaces'
            }, {
              link: 'management:settings'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.kibana', {
              defaultMessage: 'Kibana'
            })
          }, {
            children: [{
              link: 'management:license_management'
            }, {
              link: 'management:upgrade_assistant'
            }],
            title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.management.stack', {
              defaultMessage: 'Stack'
            })
          }],
          id: _deeplinksManagement.STACK_MANAGEMENT_NAV_ID,
          // This id can't be changed as we use it to open the panel programmatically
          renderAs: 'panelOpener',
          title: _i18n.i18n.translate('xpack.enterpriseSearch.searchNav.mngt', {
            defaultMessage: 'Stack Management'
          })
        }]
      };
      return navTree;
    })),
    title
  };
};
exports.getNavigationTreeDefinition = getNavigationTreeDefinition;