"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountKibanaLogic = exports.KibanaLogic = void 0;
var _kea = require("kea");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _http = require("../http");
var _react_router_helpers = require("../react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KibanaLogic = exports.KibanaLogic = (0, _kea.kea)({
  actions: {
    setUser: user => ({
      user
    })
  },
  path: ['enterprise_search', 'kibana_logic'],
  reducers: ({
    props
  }) => ({
    application: [props.application, {}],
    capabilities: [props.capabilities, {}],
    charts: [props.charts || null, {}],
    cloud: [props.cloud || null, {}],
    config: [props.config || null, {}],
    connectorTypes: [props.connectorTypes || [], {}],
    consolePlugin: [props.console || null, {}],
    data: [props.data || null, {}],
    esConfig: [props.esConfig || {
      elasticsearch_host: _searchSharedUi.ELASTICSEARCH_URL_PLACEHOLDER
    }, {}],
    fleet: [props.fleet || null, {}],
    getChromeStyle$: [props.getChromeStyle$, {}],
    getNavLinks: [props.getNavLinks, {}],
    history: [props.history, {}],
    indexMappingComponent: [props.indexMappingComponent || null, {}],
    isSidebarEnabled: [props.isSidebarEnabled, {}],
    kibanaVersion: [props.kibanaVersion || null, {}],
    lens: [props.lens || null, {}],
    ml: [props.ml || null, {}],
    navigateToUrl: [(url, options) => {
      const deps = {
        history: props.history,
        http: _http.HttpLogic.values.http
      };
      const href = (0, _react_router_helpers.createHref)(url, deps, options);
      return props.navigateToUrl(href);
    }, {}],
    productFeatures: [props.productFeatures, {}],
    renderHeaderActions: [props.renderHeaderActions, {}],
    searchNavigation: [props.searchNavigation, {}],
    security: [props.security || null, {}],
    setBreadcrumbs: [props.setBreadcrumbs, {}],
    setChromeIsVisible: [props.setChromeIsVisible, {}],
    setDocTitle: [props.setDocTitle, {}],
    share: [props.share || null, {}],
    uiActions: [props.uiActions, {}],
    uiSettings: [props.uiSettings, {}],
    updateSideNavDefinition: [props.updateSideNavDefinition, {}],
    user: [props.user || null, {
      setUser: (_, {
        user
      }) => user || null
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    isAgentlessEnabled: [() => [selectors.cloud, selectors.fleet], (cloud, fleet) => {
      var _fleet$config, _fleet$config$agentle;
      return ((cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) || (cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled)) && (fleet === null || fleet === void 0 ? void 0 : (_fleet$config = fleet.config) === null || _fleet$config === void 0 ? void 0 : (_fleet$config$agentle = _fleet$config.agentless) === null || _fleet$config$agentle === void 0 ? void 0 : _fleet$config$agentle.enabled) === true;
    }],
    isCloud: [() => [selectors.cloud], cloud => Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled)],
    isServerless: [() => [selectors.cloud], cloud => Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled)]
  })
});
const mountKibanaLogic = props => {
  var _props$coreSecurity, _props$coreSecurity$a;
  KibanaLogic(props);
  const unmount = KibanaLogic.mount();
  (_props$coreSecurity = props.coreSecurity) === null || _props$coreSecurity === void 0 ? void 0 : (_props$coreSecurity$a = _props$coreSecurity.authc.getCurrentUser()) === null || _props$coreSecurity$a === void 0 ? void 0 : _props$coreSecurity$a.then(user => {
    KibanaLogic.actions.setUser(user);
  });
  return unmount;
};
exports.mountKibanaLogic = mountKibanaLogic;