"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addConnector = exports.AddConnectorApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addConnector = async ({
  deleteExistingConnector,
  indexName,
  name,
  isNative,
  language,
  serviceType,
  uiFlags
}) => {
  const route = '/internal/enterprise_search/connectors';
  const deleteParam = deleteExistingConnector ? {
    delete_existing_connector: deleteExistingConnector
  } : {};
  const params = {
    ...deleteParam,
    index_name: indexName,
    is_native: isNative,
    language,
    name,
    service_type: serviceType
  };
  const result = await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(params)
  });
  return {
    id: result.id,
    indexName: result.index_name,
    uiFlags
  };
};
exports.addConnector = addConnector;
const AddConnectorApiLogic = exports.AddConnectorApiLogic = (0, _create_api_logic.createApiLogic)(['add_connector_api_logic'], addConnector);