"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteSearchApplication = exports.DeleteSearchApplicationAPILogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteSearchApplication = async ({
  searchApplicationName
}) => {
  const route = `/internal/enterprise_search/search_applications/${searchApplicationName}`;
  await _http.HttpLogic.values.http.delete(route);
  return {
    searchApplicationName
  };
};
exports.deleteSearchApplication = deleteSearchApplication;
const DeleteSearchApplicationAPILogic = exports.DeleteSearchApplicationAPILogic = (0, _create_api_logic.createApiLogic)(['search_applications', 'delete_search_application_api_logic'], deleteSearchApplication, {
  showSuccessFlashFn: ({
    searchApplicationName
  }) => _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.deleteSearchApplication.successToast.title', {
    defaultMessage: '{searchApplicationName} has been deleted',
    values: {
      searchApplicationName
    }
  })
});