"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverLink = void 0;
var _kea = require("kea");
var _kibana = require("../../../shared/kibana");
var _analytics_collection_data_view_logic = require("./analytics_collection_data_view_logic");
var _analytics_collection_toolbar_logic = require("./analytics_collection_toolbar/analytics_collection_toolbar_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverLink = () => {
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    dataView
  } = (0, _kea.useValues)(_analytics_collection_data_view_logic.AnalyticsCollectionDataViewLogic);
  const {
    refreshInterval,
    timeRange
  } = (0, _kea.useValues)(_analytics_collection_toolbar_logic.AnalyticsCollectionToolbarLogic);
  return dataView ? application.getUrlForApp('discover', {
    path: `#/?_a=(index:'${dataView.id}')&_g=(filters:!(),refreshInterval:(pause:!${refreshInterval.pause.toString().charAt(0)},value:${refreshInterval.value}),time:(from:${timeRange.from},to:${timeRange.to}))`
  }) : null;
};
exports.useDiscoverLink = useDiscoverLink;