"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  elserInferenceId: _configSchema.schema.string({
    defaultValue: _inferenceCommon.defaultInferenceEndpoints.ELSER
  }),
  responseTimeout: _configSchema.schema.number({
    defaultValue: 10 * 60 * 1000 // 10 minutes
  })
});