"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryScheduleUpdatePropsToApi = void 0;
var _transform_attack_discovery_schedule_actions_props_to_api = require("../transform_attack_discovery_schedule_actions_props_to_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAttackDiscoveryScheduleUpdatePropsToApi = updateProps => {
  var _transformAttackDisco;
  return {
    name: updateProps.name,
    params: {
      alerts_index_pattern: updateProps.params.alertsIndexPattern,
      api_config: updateProps.params.apiConfig,
      end: updateProps.params.end,
      query: updateProps.params.query,
      filters: updateProps.params.filters,
      combined_filter: updateProps.params.combinedFilter,
      size: updateProps.params.size,
      start: updateProps.params.start
    },
    schedule: updateProps.schedule,
    actions: (_transformAttackDisco = (0, _transform_attack_discovery_schedule_actions_props_to_api.transformAttackDiscoveryScheduleActionsPropsToApi)(updateProps.actions)) !== null && _transformAttackDisco !== void 0 ? _transformAttackDisco : []
  };
};
exports.transformAttackDiscoveryScheduleUpdatePropsToApi = transformAttackDiscoveryScheduleUpdatePropsToApi;