"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryAlert = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../conversations/common_attributes.gen");
var _common_attributes2 = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: An Attack discovery that is persisted as a (security) alert
 *   version: not applicable
 */

/**
 * An attack discovery that's also an alert
 */

const AttackDiscoveryAlert = exports.AttackDiscoveryAlert = _zod.z.object({
  /**
   * The alert IDs that the attack discovery is based on
   */
  alertIds: _zod.z.array(_zod.z.string()),
  /**
   * The optional kibana.alert.rule.uuid of the rule that generated this attack discovery (not applicable to ad hock runs)
   */
  alertRuleUuid: _zod.z.string().optional(),
  /**
   * The optional kibana.alert.workflow_status of this attack discovery
   */
  alertWorkflowStatus: _zod.z.string().optional(),
  /**
   * The ID of the connector that generated the attack discovery
   */
  connectorId: _zod.z.string(),
  /**
   * The (human readable) name of the connector that generated the attack discovery
   */
  connectorName: _zod.z.string(),
  /**
   * The optional time the attack discovery alert was created
   */
  alertStart: _zod.z.string().optional(),
  /**
   * The optional time the attack discovery alert was last updated
   */
  alertUpdatedAt: _zod.z.string().optional(),
  /**
   * The optional id of the user who last updated the attack discovery alert
   */
  alertUpdatedByUserId: _zod.z.string().optional(),
  /**
   * The optional username of the user who updated the attack discovery alert
   */
  alertUpdatedByUserName: _zod.z.string().optional(),
  /**
   * The optional time the attack discovery alert workflow status was last updated
   */
  alertWorkflowStatusUpdatedAt: _zod.z.string().optional(),
  /**
   * Details of the attack with bulleted markdown that always uses special syntax for field names and values from the source data.
   */
  detailsMarkdown: _zod.z.string(),
  /**
   * An optional, short (no more than a sentence) summary of the attack discovery featuring only the host.name and user.name fields (when they are applicable), using the same syntax
   */
  entitySummaryMarkdown: _zod.z.string().optional(),
  /**
   * The generation ID of the run that created the attack discovery
   */
  generationUuid: _zod.z.string(),
  /**
   * The unique ID of the attack discovery
   */
  id: _zod.z.string(),
  /**
   * An optional array of MITRE ATT&CK tactic for the attack discovery
   */
  mitreAttackTactics: _zod.z.array(_zod.z.string()).optional(),
  /**
   * Key-value pairs that are used to replace placeholders in the markdown fields
   */
  replacements: _common_attributes.Replacements.optional(),
  /**
   * The optional, (but typically populated after generation) risk score of the alert
   */
  riskScore: _zod.z.number().int().optional(),
  /**
   * A markdown summary of attack discovery, using the same syntax
   */
  summaryMarkdown: _zod.z.string(),
  /**
   * The time the attack discovery was generated
   */
  timestamp: _common_attributes2.NonEmptyTimestamp,
  /**
   * A title for the attack discovery, in plain text
   */
  title: _zod.z.string(),
  /**
   * The optional id of the user who generated the attack discovery
   */
  userId: _zod.z.string().optional(),
  /**
   * The optional username of the user who generated the attack discovery, (not applicable to attack discoveries generated by rules)
   */
  userName: _zod.z.string().optional(),
  /**
   * The optional array of users who may view the attack discovery. When empty, (or not present), all users may view the attack discovery.
   */
  users: _zod.z.array(_common_attributes2.User).optional()
});