"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartWithCustomButtons = void 0;
var _unifiedHistogram = require("@kbn/unified-histogram");
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireWildcard(require("react"));
var _redux = require("../../../../../application/main/state_management/redux");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/example/example_data_source_profile/components/chart_with_custom_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartWithCustomButtons = ({
  actions,
  ...props
}) => {
  const {
    isComponentVisible,
    fetch$,
    fetchParams,
    onBrushEnd,
    renderToggleActions,
    services
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiPalette = (0, _eui.euiPaletteColorBlind)();
  const {
    openInNewTab,
    updateESQLQuery
  } = actions;
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const updateAppState = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.updateAppState);
  const handleBreakdownFieldChange = (0, _react2.useCallback)(breakdownField => {
    dispatch(updateAppState({
      appState: {
        breakdownField: breakdownField === null || breakdownField === void 0 ? void 0 : breakdownField.name
      }
    }));
  }, [dispatch, updateAppState]);
  const lensAttributes = (0, _react2.useMemo)(() => {
    const {
      dataView,
      query,
      timeInterval
    } = fetchParams;
    if (!dataView.isTimeBased() || !dataView.timeFieldName) return null;
    const LAYER_ID = 'exampleHistogramLayer';
    const columns = {
      date_column: {
        dataType: 'date',
        isBucketed: true,
        label: dataView.timeFieldName,
        operationType: 'date_histogram',
        params: {
          interval: timeInterval || 'auto'
        },
        scale: 'interval',
        sourceField: dataView.timeFieldName
      },
      count_column: {
        dataType: 'number',
        isBucketed: false,
        label: 'Count of records',
        operationType: 'count',
        params: {
          format: {
            id: 'number',
            params: {
              decimals: 0
            }
          }
        },
        scale: 'ratio',
        sourceField: '___records___'
      }
    };
    return {
      references: [{
        id: dataView.id || '',
        name: `indexpattern-datasource-layer-${LAYER_ID}`,
        type: 'index-pattern'
      }],
      state: {
        adHocDataViews: {},
        datasourceStates: {
          formBased: {
            layers: {
              [LAYER_ID]: {
                columnOrder: ['date_column', 'count_column'],
                columns,
                indexPatternId: dataView.id
              }
            }
          }
        },
        filters: [],
        internalReferences: [],
        query: query || {
          language: 'kuery',
          query: ''
        },
        visualization: {
          layers: [{
            accessors: ['count_column'],
            layerId: LAYER_ID,
            layerType: 'data',
            seriesType: 'bar_stacked',
            xAccessor: 'date_column',
            yConfig: [{
              forAccessor: 'count_column',
              color: euiPalette[4]
            }]
          }],
          legend: {
            isVisible: true,
            position: 'right'
          },
          preferredSeriesType: 'bar_stacked',
          showCurrentTimeMarker: true,
          valueLabels: 'hide'
        }
      },
      title: 'Histogram',
      visualizationType: 'lnsXY'
    };
  }, [euiPalette, fetchParams, services]);
  const [externalAttributes, setExternalAttributes] = (0, _react2.useState)(null);
  (0, _react2.useEffect)(() => {
    const subscription = fetch$.subscribe(({
      lensVisServiceState
    }) => {
      var _lensVisServiceState$;
      if (lensVisServiceState !== null && lensVisServiceState !== void 0 && (_lensVisServiceState$ = lensVisServiceState.visContext) !== null && _lensVisServiceState$ !== void 0 && _lensVisServiceState$.attributes) {
        setExternalAttributes(lensVisServiceState.visContext.attributes);
      }
    });
    return () => subscription.unsubscribe();
  }, [fetch$]);
  const handleBrushEnd = (0, _react2.useCallback)(data => {
    data.preventDefault();
    if (onBrushEnd) {
      onBrushEnd(data);
    } else if (data.range.length >= 2) {
      const [min, max] = data.range;
      const from = new Date(min).toISOString();
      const to = new Date(max).toISOString();
      services.data.query.timefilter.timefilter.setTime({
        from,
        to,
        mode: 'absolute'
      });
    }
  }, [onBrushEnd, services.data.query.timefilter.timefilter]);
  const onLoad = (0, _react2.useCallback)(() => {}, []);
  if (!isComponentVisible) return null;
  const finalAttributes = externalAttributes || lensAttributes;
  const chartCss = (0, _react.css)`
    flex-grow: 1;
    margin-block: ${euiTheme.size.xs};
    min-height: 200px;
    position: relative;
    & > div {
      height: 100%;
      position: absolute;
      width: 100%;
    }
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    className: "unifiedHistogram__chart",
    css: (0, _react.css)`
        margin: ${euiTheme.size.s};
      `,
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, renderToggleActions()), fetchParams.breakdown && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_unifiedHistogram.UnifiedBreakdownFieldSelector, {
    breakdown: fetchParams.breakdown,
    dataView: fetchParams.dataView,
    onBreakdownFieldChange: handleBreakdownFieldChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  })), updateESQLQuery && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: "text",
    "data-test-subj": "exampleChartUpdateEsqlQuery",
    iconType: "editorCodeBlock",
    onClick: () => updateESQLQuery('FROM my-example-logs | LIMIT 50'),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, "Update ES|QL query")), openInNewTab && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    color: "text",
    "data-test-subj": "exampleChartOpenNewTab",
    iconType: "popout",
    onClick: () => openInNewTab({
      query: {
        esql: 'FROM my-example-logs | LIMIT 100'
      },
      tabLabel: 'Example Logs Tab',
      timeRange: {
        from: 'now-1d',
        to: 'now'
      }
    }),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 15
    }
  }, "Open new tab")))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }, finalAttributes ? /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "exampleHistogramChart",
    css: chartCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(services.lens.EmbeddableComponent, {
    abortController: fetchParams.abortController,
    attributes: finalAttributes,
    executionContext: {
      description: 'example chart'
    },
    forceDSL: true,
    id: "exampleHistogramLens",
    lastReloadRequestTime: fetchParams.lastReloadRequestTime,
    onBrushEnd: handleBrushEnd,
    noPadding: true,
    onLoad: onLoad,
    searchSessionId: fetchParams.searchSessionId,
    timeRange: fetchParams.timeRange,
    viewMode: "view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: {
      minHeight: 200
    },
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }, "Chart not available"))));
};
exports.ChartWithCustomButtons = ChartWithCustomButtons;