"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMetricsDataSourceProfileProvider = exports.METRICS_DATA_SOURCE_PROFILE_ID = void 0;
var _esQuery = require("@kbn/es-query");
var _esqlAst = require("@kbn/esql-ast");
var _constants = require("../../../../../common/constants");
var _profiles = require("../../../profiles");
var _chart_section = require("./accessor/chart_section");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const METRICS_DATA_SOURCE_PROFILE_ID = exports.METRICS_DATA_SOURCE_PROFILE_ID = 'metrics-data-source-profile';
// FIXME: could kbn-esql-ast provide a union type with existing commands?
const SUPPORTED_ESQL_COMMANDS = new Set(['ts', 'limit', 'sort']);
const createMetricsDataSourceProfileProvider = services => ({
  profileId: METRICS_DATA_SOURCE_PROFILE_ID,
  restrictedToProductFeature: _constants.METRICS_EXPERIENCE_PRODUCT_FEATURE_ID,
  profile: {
    getChartSectionConfiguration: (0, _chart_section.createChartSection)(services.metricsContextService.getMetricsExperienceClient())
  },
  resolve: async ({
    query,
    rootContext
  }) => {
    if (!isQuerySupported(query) || !isSolutionValid(rootContext.solutionType)) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Metrics
      }
    };
  }
});
exports.createMetricsDataSourceProfileProvider = createMetricsDataSourceProfileProvider;
function isSolutionValid(solutionType) {
  return [_profiles.SolutionType.Observability, _profiles.SolutionType.Security, _profiles.SolutionType.Search, _profiles.SolutionType.Default].includes(solutionType);
}
function isQuerySupported(query) {
  if (!(0, _esQuery.isOfAggregateQueryType)(query)) {
    return false;
  }
  const parsed = _esqlAst.Parser.parse(query.esql);
  return parsed.root.commands.every(c => SUPPORTED_ESQL_COMMANDS.has(c.name));
}