"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEqualFilters = isEqualFilters;
exports.isEqualState = isEqualState;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Helper function to compare 2 different filter states
 */
function isEqualFilters(filtersA, filtersB, comparatorOptions = _esQuery.COMPARE_ALL_OPTIONS) {
  if (!filtersA && !filtersB) {
    return true;
  } else if (!filtersA || !filtersB) {
    return false;
  }
  return (0, _esQuery.compareFilters)(filtersA, filtersB, comparatorOptions);
}

/**
 * Helper function to compare 2 different state, is needed since comparing filters
 * works differently
 */
function isEqualState(stateA, stateB, exclude = []) {
  if (!stateA && !stateB) {
    return true;
  } else if (!stateA || !stateB) {
    return false;
  }
  const {
    filters: stateAFilters = [],
    ...stateAPartial
  } = (0, _lodash.omit)(stateA, exclude);
  const {
    filters: stateBFilters = [],
    ...stateBPartial
  } = (0, _lodash.omit)(stateB, exclude);
  return (0, _lodash.isEqual)(stateAPartial, stateBPartial) && isEqualFilters(stateAFilters, stateBFilters);
}