"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleTabView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useLatest = _interopRequireDefault(require("react-use/lib/useLatest"));
var _data_sources = require("../../../../../common/data_sources");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _discover_state = require("../../state_management/discover_state");
var _redux = require("../../state_management/redux");
var _customizations = require("../../../../customizations");
var _no_data_page = require("./no_data_page");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _branded_loading_indicator = require("./branded_loading_indicator");
var _main_app = require("./main_app");
var _scoped_services_provider = require("../../../../components/scoped_services_provider");
var _hide_tabs_bar = require("../tabs_view/hide_tabs_bar");
var _initialization_error = require("./initialization_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/single_tab_view/single_tab_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SingleTabView = ({
  customizationContext,
  customizationCallbacks,
  urlStateStorage,
  internalState,
  runtimeStateManager,
  searchSessionManager
}) => {
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const appInitializationState = (0, _redux.useInternalStateSelector)(state => state.initializationState);
  const currentTabId = (0, _redux.useCurrentTabSelector)(tab => tab.id);
  const currentTabInitializationState = (0, _redux.useCurrentTabSelector)(tab => tab.initializationState);
  const currentStateContainer = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.stateContainer$);
  const currentCustomizationService = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.customizationService$);
  const scopedProfilesManager = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.scopedProfilesManager$);
  const scopedEbtManager = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.scopedEbtManager$);
  const currentDataView = (0, _redux.useCurrentTabRuntimeState)(runtimeStateManager, tab => tab.currentDataView$);
  const adHocDataViews = (0, _redux.useRuntimeState)(runtimeStateManager.adHocDataViews$);
  const initializeSingleTab = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.initializeSingleTab);
  const initializeTab = (0, _useLatest.default)(async ({
    dataViewSpec,
    defaultUrlState,
    esqlControls
  } = {}) => {
    const stateContainer = (0, _discover_state.getDiscoverStateContainer)({
      tabId: currentTabId,
      services,
      customizationContext,
      stateStorageContainer: urlStateStorage,
      internalState,
      runtimeStateManager,
      searchSessionManager
    });
    const customizationService = await (0, _customizations.getConnectedCustomizationService)({
      stateContainer,
      customizationCallbacks,
      services
    });
    dispatch(initializeSingleTab({
      initializeSingleTabParams: {
        stateContainer,
        customizationService,
        dataViewSpec,
        esqlControls,
        defaultUrlState
      }
    }));
  });
  (0, _react.useEffect)(() => {
    if (currentTabInitializationState.initializationStatus === _redux.TabInitializationStatus.NotStarted) {
      var _services$getScopedHi;
      const historyLocationState = (_services$getScopedHi = services.getScopedHistory()) === null || _services$getScopedHi === void 0 ? void 0 : _services$getScopedHi.location.state;
      initializeTab.current({
        dataViewSpec: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.dataViewSpec,
        esqlControls: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.esqlControls,
        defaultUrlState: historyLocationState === null || historyLocationState === void 0 ? void 0 : historyLocationState.defaultState
      });
    }
  }, [currentTabInitializationState.initializationStatus, initializeTab, services]);
  if (currentTabInitializationState.initializationStatus === _redux.TabInitializationStatus.Error) {
    return /*#__PURE__*/_react.default.createElement(_initialization_error.InitializationError, {
      error: currentTabInitializationState.error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 12
      }
    });
  }
  if (currentTabInitializationState.initializationStatus === _redux.TabInitializationStatus.NoData) {
    return /*#__PURE__*/_react.default.createElement(_hide_tabs_bar.HideTabsBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_no_data_page.NoDataPage, (0, _extends2.default)({}, appInitializationState, {
      onDataViewCreated: async dataViewUnknown => {
        await dispatch(_redux.internalStateActions.loadDataViewList());
        dispatch(_redux.internalStateActions.setInitializationState({
          hasESData: true,
          hasUserDataView: true
        }));
        const dataView = dataViewUnknown;
        initializeTab.current({
          defaultUrlState: dataView.id ? {
            dataSource: (0, _data_sources.createDataViewDataSource)({
              dataViewId: dataView.id
            })
          } : undefined
        });
      },
      onESQLNavigationComplete: () => {
        initializeTab.current();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    })));
  }
  if (!currentStateContainer || !currentCustomizationService || !currentDataView) {
    return /*#__PURE__*/_react.default.createElement(_branded_loading_indicator.BrandedLoadingIndicator, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_customizations.DiscoverCustomizationProvider, {
    value: currentCustomizationService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_discover_state_provider.DiscoverMainProvider, {
    value: currentStateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_redux.RuntimeStateProvider, {
    currentDataView: currentDataView,
    adHocDataViews: adHocDataViews,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_scoped_services_provider.ScopedServicesProvider, {
    scopedProfilesManager: scopedProfilesManager,
    scopedEBTManager: scopedEbtManager,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_main_app.DiscoverMainApp, {
    stateContainer: currentStateContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  })))));
};
exports.SingleTabView = SingleTabView;