"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransformOut = getTransformOut;
var _common = require("@kbn/saved-search-plugin/common");
var _search_inject_extract = require("./search_inject_extract");
var _get_transform_in = require("./get_transform_in");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isByValue(state) {
  return typeof state.attributes === 'object' && state.attributes !== null;
}
function getTransformOut(transformEnhancementsOut) {
  function transformOut(state, references) {
    const enhancementsState = state.enhancements ? transformEnhancementsOut(state.enhancements, references !== null && references !== void 0 ? references : []) : undefined;
    const enhancements = enhancementsState ? {
      enhancements: enhancementsState
    } : {};
    if (isByValue(state)) {
      const tabsState = {
        ...state,
        attributes: (0, _common.extractTabs)(state.attributes)
      };
      const {
        attributes
      } = (0, _search_inject_extract.inject)({
        type: _common.SavedSearchType,
        ...tabsState
      }, references !== null && references !== void 0 ? references : []);
      return {
        ...state,
        attributes,
        ...enhancements
      };
    }
    const savedObjectRef = (references !== null && references !== void 0 ? references : []).find(ref => _common.SavedSearchType === ref.type && ref.name === _get_transform_in.SAVED_SEARCH_SAVED_OBJECT_REF_NAME);
    return {
      ...state,
      ...enhancements,
      ...(savedObjectRef !== null && savedObjectRef !== void 0 && savedObjectRef.id ? {
        savedObjectId: savedObjectRef.id
      } : {})
    };
  }
  return transformOut;
}