"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAppLocatorParams = exports.appLocatorGetLocationCommon = void 0;
var _esQuery = require("@kbn/es-query");
var _data_sources = require("./data_sources");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const appLocatorGetLocationCommon = async ({
  useHash: useHashOriginal,
  setStateToKbnUrl
}, ...[params]) => {
  const {
    useHash = useHashOriginal,
    savedSearchId,
    searchSessionId,
    tab
  } = params;
  const savedSearchPath = savedSearchId ? `view/${encodeURIComponent(savedSearchId)}` : '';
  let path = `#/${savedSearchPath}`;
  if (searchSessionId) {
    path = `${path}?searchSessionId=${searchSessionId}`;
  }
  const {
    appState,
    globalState,
    state
  } = parseAppLocatorParams(params);
  if (Object.keys(globalState).length) {
    path = setStateToKbnUrl(_constants.GLOBAL_STATE_URL_KEY, globalState, {
      useHash
    }, path);
  }
  if (Object.keys(appState).length) {
    path = setStateToKbnUrl(_constants.APP_STATE_URL_KEY, appState, {
      useHash
    }, path);
  }
  if (tab !== null && tab !== void 0 && tab.id) {
    path = setStateToKbnUrl(_constants.TAB_STATE_URL_KEY, {
      tabId: tab.id,
      tabLabel: 'label' in tab ? tab.label : undefined
    }, {
      useHash
    }, path);
  }
  return {
    app: 'discover',
    path,
    state
  };
};
exports.appLocatorGetLocationCommon = appLocatorGetLocationCommon;
const parseAppLocatorParams = params => {
  const {
    filters,
    dataViewId,
    indexPatternId,
    dataViewSpec,
    query,
    refreshInterval,
    timeRange,
    columns,
    grid,
    savedQuery,
    sort,
    interval,
    viewMode,
    hideAggregatedPreview,
    breakdownField,
    hideChart,
    sampleSize,
    isAlertResults,
    esqlControls
  } = params;
  const appState = {};
  const globalState = {};
  if (query) appState.query = query;
  if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !(0, _esQuery.isFilterPinned)(f));
  if (indexPatternId) appState.dataSource = (0, _data_sources.createDataViewDataSource)({
    dataViewId: indexPatternId
  });
  if (dataViewId) appState.dataSource = (0, _data_sources.createDataViewDataSource)({
    dataViewId
  });
  if ((0, _esQuery.isOfAggregateQueryType)(query)) appState.dataSource = (0, _data_sources.createEsqlDataSource)();
  if (columns) appState.columns = columns;
  if (grid) appState.grid = grid;
  if (savedQuery) appState.savedQuery = savedQuery;
  if (sort) appState.sort = sort;
  if (interval) appState.interval = interval;
  if (timeRange) globalState.time = timeRange;
  if (filters && filters.length) globalState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => (0, _esQuery.isFilterPinned)(f));
  if (refreshInterval) globalState.refreshInterval = refreshInterval;
  if (viewMode) appState.viewMode = viewMode;
  if (hideAggregatedPreview) appState.hideAggregatedPreview = hideAggregatedPreview;
  if (breakdownField) appState.breakdownField = breakdownField;
  if (typeof hideChart === 'boolean') appState.hideChart = hideChart;
  if (typeof sampleSize === 'number' && sampleSize > 0) appState.sampleSize = sampleSize;
  const state = {};
  if (dataViewSpec) state.dataViewSpec = dataViewSpec;
  if (isAlertResults) state.isAlertResults = isAlertResults;
  if (esqlControls) state.esqlControls = esqlControls;
  return {
    appState,
    globalState,
    state
  };
};
exports.parseAppLocatorParams = parseAppLocatorParams;