"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = OverviewHeader;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _hooks = require("../../../hooks");
var _use_kibana = require("../../../utils/use_kibana");
var _translations = require("../../../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function OverviewHeader({
  handleTimeChange
}) {
  const {
    timeRange
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    unifiedSearch
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const onTimeChange = (0, _react2.useCallback)(({
    ...timeRangeProps
  }) => {
    handleTimeChange({
      ...timeRangeProps
    });
  }, [handleTimeChange]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          flex-grow: 1;
        `,
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, _translations.overviewHeaderTitle))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
          flex-grow: 0;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(unifiedSearch.ui.SearchBar, {
    appName: "datasetQualityDetails",
    showDatePicker: true,
    showFilterBar: false,
    showQueryMenu: false,
    showQueryInput: false,
    submitButtonStyle: "iconOnly",
    displayStyle: "inPage",
    disableQueryLanguageSwitcher: true,
    query: undefined,
    dateRangeFrom: timeRange.from,
    dateRangeTo: timeRange.to,
    onQuerySubmit: payload => onTimeChange(payload.dateRange),
    isAutoRefreshDisabled: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })));
}
module.exports = exports.default;