"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_custom_integration = require("./register_custom_integration");
var _routes = require("./routes");
var _constants = require("../common/embeddables/constants");
var _transform_in = require("../common/embeddables/transform_in");
var _transform_out = require("../common/embeddables/transform_out");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataVisualizerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "_logger", void 0);
    this._logger = initializerContext.logger.get();
  }
  setup(coreSetup, plugins) {
    if (plugins.home && plugins.customIntegrations) {
      (0, _register_custom_integration.registerWithCustomIntegrations)(plugins.customIntegrations);
    }
    (0, _routes.routes)(coreSetup, this._logger);
    plugins.embeddable.registerTransforms(_constants.FIELD_STATS_EMBEDDABLE_TYPE, {
      transformOutInjectsReferences: true,
      transformIn: _transform_in.transformIn,
      transformOut: _transform_out.transformOut
    });
  }
  start(core) {}
}
exports.DataVisualizerPlugin = DataVisualizerPlugin;